<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Coursecta_Title extends BLOGINAC_Elementor_CourseCTA
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Start Title Style Section
        $this->start_controls_section(
            'section_course_title_styles',
            [
                'label' => __('Title Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ],

        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .course-post-title h3',
            ]
        );

        // Title Color Control
        $this->add_control(
            'course_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-title h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'course_title_underline_color',
            [
                'label' => __('Title Underline Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-title .blg-title-underline' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
