<?php
// Prevent direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Controls_Title')):

/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Experts_Title extends BLOGINAC_Elementor_Experts {

    /**
     * Add title style controls
     */
    public function register_controls() {
        // Start Title Style Section
        $this->start_controls_section(
            'section_title_styles',
            [
                'label' => __('Title Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ],

        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .experts-post-title h3',
            ]
        );

        // Title Color Control
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .experts-post-title h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_underline_color',
            [
                'label' => __('Title Underline Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .experts-post-title .blg-title-underline' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => __('Description Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .experts-post-desc',
            ]
        );

        // Title Color Control
        $this->add_control(
            'desc_color',
            [
                'label' => __('Description Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .experts-post-desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}

endif;
