<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Television_Settings extends BLOGINAC_Elementor_Television
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Get all video categories (assuming you have a custom taxonomy for video categories)
        $categories = get_terms([
            'taxonomy'   => BLOGINAC_Base::TAX_TELEVISION_CATEGORY, // Replace with your video taxonomy
            'hide_empty' => true,
        ]);

        $categories_options = [
            '' => __('All Categories', BLOGINAC_TEXT_DOMAIN)
        ];

        foreach ($categories as $category) {
            $categories_options[$category->term_id] = $category->name;
        }

        // Define ordering options
        $order_options = [
            'date'  => __('Date', BLOGINAC_TEXT_DOMAIN),
            'title' => __('Title', BLOGINAC_TEXT_DOMAIN),
            'rand'  => __('Random', BLOGINAC_TEXT_DOMAIN),
        ];

        // Layout Options
        $layout_options = [
            'grid'    => __('Grid', BLOGINAC_TEXT_DOMAIN),
            'list'    => __('List', BLOGINAC_TEXT_DOMAIN),
            'carousel' => __('Carousel', BLOGINAC_TEXT_DOMAIN),
        ];

        // Video Section Controls
        $this->start_controls_section(
            'video_section',
            [
                'label' => __('Blogina Video Settings', BLOGINAC_TEXT_DOMAIN),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Number of Videos Control
        $this->add_control(
            'videos_count',
            [
                'label'       => __('Number of Videos', BLOGINAC_TEXT_DOMAIN),
                'type'        => \Elementor\Controls_Manager::NUMBER,
                'default'     => 6,
                'min'         => 1,
                'max'         => 20,
                'step'        => 1,
                'description' => __('Number of videos to display.', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Video Category Control
        $this->add_control(
            'video_category',
            [
                'label'       => __('Video Category', BLOGINAC_TEXT_DOMAIN),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => $categories_options,
                'default'     => '',
                'description' => __('Select category for the video section.', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Video Order Control
        $this->add_control(
            'video_order',
            [
                'label'       => __('Video Order By', BLOGINAC_TEXT_DOMAIN),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => $order_options,
                'default'     => 'rand',
                'description' => __('Select order by for the video section.', BLOGINAC_TEXT_DOMAIN),
            ]
        );
        $this->add_control(
            'video',
            [
                'label' => __( 'Enable Video', BLOGINAC_TEXT_DOMAIN ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', BLOGINAC_TEXT_DOMAIN ),
                'label_off' => __( 'No', BLOGINAC_TEXT_DOMAIN ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Autoplay Control (toggle for enabling/disabling autoplay)
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Autoplay Video', BLOGINAC_TEXT_DOMAIN ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', BLOGINAC_TEXT_DOMAIN ),
                'label_off' => __( 'No', BLOGINAC_TEXT_DOMAIN ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Controls Control (toggle for enabling/disabling video controls)
        $this->add_control(
            'controls',
            [
                'label' => __( 'Show Controls', BLOGINAC_TEXT_DOMAIN ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', BLOGINAC_TEXT_DOMAIN ),
                'label_off' => __( 'No', BLOGINAC_TEXT_DOMAIN ),
                'return_value' => 'yes',
                'default' => 'yes', // Default to controls enabled
            ]
        );

        // Show/Hide Video Title
        $this->add_control(
            'show_video_title',
            [
                'label'        => __('Show Video Title', BLOGINAC_TEXT_DOMAIN),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __('Show', BLOGINAC_TEXT_DOMAIN),
                'label_off'    => __('Hide', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // Show/Hide Video Duration
        $this->add_control(
            'show_video_duration',
            [
                'label'        => __('Show Video Duration', BLOGINAC_TEXT_DOMAIN),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __('Show', BLOGINAC_TEXT_DOMAIN),
                'label_off'    => __('Hide', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'main_title',
            [
                'label' => __('Main Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Blogina Television', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'show_buttons',
            [
                'label' => __('Show Buttons', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'button_text',
            [
                'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('view all', BLOGINAC_TEXT_DOMAIN),
                'condition' => [
                    'show_buttons' => 'yes',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
