<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_UpdatedBlog_NewsLetter extends BLOGINAC_Elementor_UpdatedBlogs
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_news_letter_styles',
            [
                'label' => __('News Letter Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE, // Add this section to the Style tab
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'news_letter_bg_color',
            [
                'label' => __('Box Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .newsletter-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'news_letter_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .newsletter-card h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'title_underline_color',
            [
                'label' => __('Title Underline Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .newsletter-card .blg-title-underline' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        // Card Border Radius Control
        $this->add_control(
            'news_letter_radius',
            [
                'label' => __('Card Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .newsletter-card' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'news_letter_shadow',
                'label' => __('Card Shadow', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .newsletter-card',
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
