<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_UpdatedBlog_Settings extends BLOGINAC_Elementor_UpdatedBlogs
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Get all categories
        $categories = get_categories();
        $categories_options = [
            '' => __('All Categories', BLOGINAC_TEXT_DOMAIN)
        ];
        foreach ($categories as $category) {
            $categories_options[$category->term_id] = $category->name;
        }

        // Define ordering options
        $order_options = [
            'date'         => __('Date (Newest First)', BLOGINAC_TEXT_DOMAIN),
            'date_asc'     => __('Date (Oldest First)', BLOGINAC_TEXT_DOMAIN),
            'modified'     => __('Last Modified (Newest First)', BLOGINAC_TEXT_DOMAIN),
            'modified_asc' => __('Last Modified (Oldest First)', BLOGINAC_TEXT_DOMAIN),
            'title'        => __('Title (A-Z)', BLOGINAC_TEXT_DOMAIN),
            'title_desc'   => __('Title (Z-A)', BLOGINAC_TEXT_DOMAIN),
            'rand'         => __('Random', BLOGINAC_TEXT_DOMAIN),
            'comment_count'=> __('Most Commented', BLOGINAC_TEXT_DOMAIN),
        ];

        // Posts Section
        $this->start_controls_section(
            'posts_section',
            [
                'label' => __('Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Start Tabs
        $this->start_controls_tabs('posts_tabs');

        // Start "Posts" Tab
        $this->start_controls_tab(
            'posts_tab',
            [
                'label' => __('Posts', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Number of Posts Control
        $this->add_control(
            'posts_count',
            [
                'label' => __('Number of Posts', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 8,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        // Main Section Category Control
        $this->add_control(
            'post_category',
            [
                'label' => __('Post Category', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $categories_options,
                'default' => '',
            ]
        );

        $this->add_control(
            'post_order',
            [
                'label' => __('Post Order By', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $order_options,
                'default' => 'modified',
            ]
        );

        $this->end_controls_tab(); // End "Posts" Tab

        // Start "Latest Posts" Tab
        $this->start_controls_tab(
            'latest_posts_tab',
            [
                'label' => __('Latest Posts', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Number of Latest Posts
        $this->add_control(
            'latest_posts_count',
            [
                'label' => __('Number of Latest Posts', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        // Latest Post Title
        $this->add_control(
            'latest_posts_title',
            [
                'label' => __('Latest Post Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'مقالات',
            ]
        );

        // Latest Post Category Control
        $this->add_control(
            'latest_post_category',
            [
                'label' => __('Latest Post Category', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $categories_options,
                'default' => '',
            ]
        );

        $this->add_control(
            'latest_post_order',
            [
                'label' => __('Latest Post Order By', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $order_options,
                'default' => 'modified',
            ]
        );

        $this->end_controls_tab(); // End "Latest Posts" Tab

        $this->end_controls_tabs(); // End Tabs

        // End Section
        $this->end_controls_section();

        // Newsletter Section
        $this->start_controls_section(
            'newsletter_section',
            [
                'label' => __('Newsletter Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Newsletter Title
        $this->add_control(
            'newsletter_title',
            [
                'label' => __('Newsletter Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'خبرنامه',
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
