<?php
// no direct access
defined('ABSPATH') || die();

if(!class_exists('BLOGINAC_Elementor_Base')):

/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version	1.0.0
 */
class BLOGINAC_Elementor_Base extends \Elementor\Widget_Base
{
    /**
     * @inheritDoc
     */
    public function get_name()
    {
    }

    public function include_elementor_html_file($file = '', $args = [])
    {
        // File is empty
        if(!trim($file)) return esc_html__('HTML file is empty!', BLOGINAC_TEXT_DOMAIN);

        // Core File
        $path = BLOGINAC_ABSPATH .'/app/html/elementor/'.ltrim($file, '/');

        // Apply Filter
        $path = apply_filters('blg_include_elementor_html_file', $path, $file, $args);

        // File is not exists
        if(!file_exists($path)) return esc_html__('Elementor HTML file is not exists! Check the file path please.', BLOGINAC_TEXT_DOMAIN);

        // Return the File Path
        if(isset($args['return_path']) && $args['return_path']) return $path;

        // Parameters passed
        if(isset($args['parameters']) && is_array($args['parameters']) && count($args['parameters'])) extract($args['parameters']);

        // Start buffering
        ob_start();

        // Include Once
        if(isset($args['include_once']) && $args['include_once']) include_once $path;
        else include $path;

        // Get Buffer
        $output = ob_get_clean();

        // Return the File OutPut
        if(isset($args['return_output']) && $args['return_output']) return $output;

        // Print the output
        echo trim($output);
        return '';
    }
}

endif;
