<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Quiz')) :

    /**
     * Elementor Survey/Quiz Widget.
     *
     * @class BLOGINAC_Elementor_Quiz
     * @version 1.1.0
     */
    class BLOGINAC_Elementor_Quiz extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-survey-quiz';
        }

        public function get_title()
        {
            return __('Survey/Quiz', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-question';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Survey Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Quiz Title
            $this->add_control(
                'quiz_title',
                [
                    'label' => __('Quiz Title', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('General Knowledge Quiz', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            // Questions and Answers Control
            $this->add_control(
                'questions',
                [
                    'label' => __('Questions', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => [
                        [
                            'name' => 'question',
                            'label' => __('Question', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => __('What is 2 + 2?', BLOGINAC_TEXT_DOMAIN),
                        ],
                        [
                            'name' => 'answers',
                            'label' => __('Answers', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => __('4, 5, 6', BLOGINAC_TEXT_DOMAIN),
                            'description' => __('Enter answers separated by commas.', BLOGINAC_TEXT_DOMAIN),
                        ],
                        [
                            'name' => 'correct_answer',
                            'label' => __('Correct Answer', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '4',
                            'description' => __('Enter the correct answer from the choices above.', BLOGINAC_TEXT_DOMAIN),
                        ],
                    ],
                    'title_field' => '{{{ question }}}',
                ]
            );

            // Display Result Label
            $this->add_control(
                'result_label',
                [
                    'label' => __('Result Label', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Your Score: ', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $quiz_title = $settings['quiz_title'];
            $questions = $settings['questions'];
            $result_label = $settings['result_label'];

            // Generate Unique ID for the widget instance
            $uniq_id = uniqid('bloginac-survey-quiz-');

            ?>
            <div id="<?php echo esc_attr($uniq_id); ?>" class="bloginac-survey">
                <h2 class="quiz-title">
                    <?php echo esc_html($quiz_title); ?>
                </h2>

                <form id="survey-quiz-form" class="survey-quiz-form">
                    <div class="survey-questions">
                        <?php foreach ($questions as $index => $question) :
                            $answers = explode(',', $question['answers']);
                            ?>
                            <div class="survey-question">
                                <p><?php echo esc_html($question['question']); ?></p>
                                <div class="survey-answers">
                                    <?php foreach ($answers as $answer) : ?>
                                        <label class="card-radio-btn">
                                            <input type="radio" class="card-input-element" name="question-<?php echo $index; ?>" value="<?php echo trim($answer); ?>">
                                            <div class="card">
                                                <div class="content_head"><?php echo esc_html(trim($answer)); ?></div>
                                            </div>
                                        </label>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>

                    </div>

                    <button type="submit" class="survey-quiz-submit blg-btn-primary-filled">
                        <?php echo __('Submit', BLOGINAC_TEXT_DOMAIN); ?>
                    </button>
                </form>

                <div id="survey-result" class="survey-result" style="display: none;">
                    <p id="survey-score"><?php echo esc_html($result_label); ?></p>
                    <div id="survey-correct-answers"></div>
                </div>
            </div>

            <script>
                (function ($) {
                    $(document).ready(function () {
                        $('#survey-quiz-form').submit(function (e) {
                            e.preventDefault();

                            var score = 0;
                            var totalQuestions = <?php echo count($questions); ?>;
                            var correctAnswers = '';

                            <?php foreach ($questions as $index => $question) : ?>
                            var selectedAnswer = $('input[name="question-<?php echo $index; ?>"]:checked').val();
                            if (selectedAnswer === '<?php echo esc_js($question['correct_answer']); ?>') {
                                score++;
                            } else {
                                correctAnswers += '<p><strong><?php echo esc_js($question['question']); ?></strong><br>' +
                                    'Correct Answer: <?php echo esc_js($question['correct_answer']); ?></p>';
                            }
                            <?php endforeach; ?>

                            var resultText = '<?php echo esc_js($result_label); ?>' + score + ' / ' + totalQuestions;
                            $('#survey-score').text(resultText);
                            $('#survey-correct-answers').html(correctAnswers);
                            $('#survey-result').show();
                            $('#survey-quiz-form').hide();
                        });
                    });
                })(jQuery);
            </script>

            <?php
        }
    }

endif;
