<?php
// no direct access
defined('ABSPATH') || die();

function blg_template($tpl, $override = true)
{
    $blg = new BLOGINAC_BASE();
    $path = $blg->get_blogina_core_path().'/templates/'.ltrim($tpl, '/');

    if($override)
    {
        // Main Theme
        $theme = get_template_directory();
        $theme_path = $theme.'/blogina-core/'.ltrim($tpl, '/');

        if(is_file($theme_path)) $path = $theme_path;

        // Child Theme
        if(is_child_theme())
        {
            $child_theme = get_stylesheet_directory();
            $child_theme_path = $child_theme.'/blogina-core/'.ltrim($tpl, '/');

            if(is_file($child_theme_path)) $path = $child_theme_path;
        }
    }

    // Apply Filter
    return apply_filters('blg_template', $path, $tpl, $override);
}