// Helper functions to create elements
function createInput(type, name, placeholder, classes, required = false, value = '') {
  return $('<input>', {
    type: type,
    name: name,
    placeholder: placeholder,
    class: classes,
    required: required,
    value: value
  });
}

function createSelect(name, options, classes, selectedValue = '') {
  const select = $('<select>', { name: name, class: classes });
  $.each(options, function (key, text) {
    const option = $('<option>', { value: key, text: text });
    if (key === selectedValue) {
      option.prop('selected', true);
    }
    select.append(option);
  });
  return select;
}

function createButton(type, classes, iconHtml, additionalAttributes = {}) {
  return $('<button>', {
    type: type,
    class: classes,
    html: iconHtml,
    ...additionalAttributes
  });
}

/**
 * Blogina Gallery Uploader
 */
(function ($) {
  // Add Image
  $("#blg_upload_gallery").on("click", function (e) {
    e.preventDefault();

    var frame = wp.media({
      title: "Select or Upload Images",
      button: {
        text: "Add to gallery",
      },
      multiple: true,
    });

    frame.on("select", function () {
      var attachments = frame.state().get("selection").toJSON();
      attachments.forEach(function (attachment) {
        $("#blg_gallery_list").append(
          "<li>" +
          '<img src="' +
          attachment.url +
          '" width="100" />' +
          '<input type="hidden" name="blg[gallery][]" value="' +
          attachment.id +
          '" />' +
          '<a href="#" class="blg-remove-image"><i class="fa fa-trash"></i></a>' +
          "</li>"
        );
      });
    });

    frame.open();
  });

  // Remove Image
  $(document).on("click", ".blg-remove-image", function (e) {
    e.preventDefault();
    $(this).closest("li").remove();
  });

  jQuery(document).ready(function ($) {
    $("#blg_upload_video").on("click", function (e) {
      e.preventDefault();

      var frame = wp.media({
        title: "Select or Upload Video",
        button: {
          text: "Add Video",
        },
        library: {
          type: "video", // Restrict media type to video
        },
        multiple: false, // Only allow one video
      });

      frame.on("select", function () {
        var attachment = frame.state().get("selection").first().toJSON();

        // Create video HTML
        var videoHtml =
          '<video width="320" height="240" controls>' +
          '<source src="' + attachment.url + '" type="video/mp4">' +
          'Your browser does not support the video tag.' +
          '</video>' +
          '<input type="hidden" name="blg[video]" value="' + attachment.id + '" />' +
          '<a href="#" class="blg-remove-video"><i class="fa fa-trash"></i></a>';

        // Replace any existing video preview
        $("#blg_video_preview").html(videoHtml);

        // Optionally, update the hidden input with video duration
        var videoElement = $('#blg_video_preview video');
        videoElement.on('loadedmetadata', function () {
          var duration = videoElement[0].duration;
          var minutes = Math.floor(duration / 60);
          var seconds = Math.floor(duration % 60);
          var formattedTime = minutes + ':' + (seconds < 10 ? '0' : '') + seconds;

          // Update the hidden input with the formatted time
          $('#blg_video_time').val(formattedTime);

          // Display the duration (optional)
          var durationElement = $('<div>').text('Duration: ' + formattedTime);
          $('#blg_video_preview').append(durationElement);
        });
      });

      frame.open();
    });

    // Remove Video Handler
    $(document).on("click", ".blg-remove-video", function (e) {
      e.preventDefault();
      // Remove the video preview and clear hidden input
      $("#blg_video_preview").html('');
      $('#blg_video_time').val('');
    });
  });

  function normalizeText(text) {
    if (!text) return '';
    return text
      .normalize('NFKC')
      .replace(/ي/g, 'ی')
      .replace(/ك/g, 'ک');
  }

  $('#redux-search').on('input', function () {
    var query = normalizeText($(this).val().toLowerCase());

    $('.redux-field-container').removeClass('highlight-match').show();
    $('.redux-group-tab-link-li').removeClass('highlight-tab').show();
    $('.redux-group-tab').removeClass('redux-tab-active').hide();
    $('.redux-search-no-results').remove();

    if (query === '') {
      // When input is cleared, show only the active tab and hide others
      $('.redux-group-tab').hide(); // Hide all tabs' content
      var activeTab = $('.redux-group-tab-link-li.active').data('rel');
      $('#' + activeTab).show(); // Show only the active tab's content
      $('.redux-group-tab-link-li.active').addClass('highlight-tab'); // Highlight the active tab
      return;
    }

    var hasMatches = false;

    $('.redux-group-tab').each(function () {
      var tab = $(this);
      var tabID = tab.attr('id');
      var tabHasMatches = false;

      tab.find('*').each(function () {
        var fieldText = normalizeText($(this).text().toLowerCase());

        if (fieldText.includes(query)) {
          $(this).addClass('highlight-match');
          tabHasMatches = true;
          hasMatches = true;
        }
      });

      if (tabHasMatches) {
        tab.show();
        $('.redux-group-tab-link-li[data-rel="' + tabID + '"]').addClass('highlight-tab').show();
      } else {
        $('.redux-group-tab-link-li[data-rel="' + tabID + '"]').hide();
      }
    });

    if (!hasMatches) {
      $('#redux-search').after('<p class="redux-search-no-results">چیزی یافت نشد.</p>');
    }
  });


})(jQuery);

// bloginaSyncCounts
(function ($) {
  $.fn.bloginaSyncCounts = function (options) {
    const settings = $.extend(
        {
          ajax_url: "",
          nonce: "",
          product_id: "",
        },
        options
    );

    let $buttons = $(".blg-button-sync");
    let ajax = false;

    setListeners();

    function setListeners() {
      $buttons.on("click", function (event) {
        event.preventDefault();

        const $button = $(this);
        const $row = $button.closest(".blg-form-row");
        const $chapterInput = $row.find("#blg_chapter_count");
        const $sessionInput = $row.find("#blg_session_count");

        // Show loading state on button
        $button.html('<i class="fa fa-spinner fa-spin"></i>');

        // Abort any previous AJAX request
        if (ajax) ajax.abort();

        // Send AJAX request
        ajax = $.ajax({
          type: "POST",
          url: settings.ajax_url,
          data: {
            action: "sync_chapter_and_session_count",
            nonce: settings.nonce,
            product_id: settings.product_id
          },
          dataType: "JSON",
          success: function (response) {
            if (response.success) {
              // Update input fields with the new counts
              $chapterInput.val(response.chapter_count);
              $sessionInput.val(response.session_count);
            } else {
              alert(response.message || "Error syncing counts.");
            }
          },
          error: function (jqXHR, textStatus, errorThrown) {
            alert(errorThrown || "An unexpected error occurred.");
          },
          complete: function () {
            // Reset button state
            $button.html('<i class="fa fa-sync"></i>');
          },
        });
      });
    }
  };
})(jQuery);

