<?php

/**
 * Custom template for the panel header area with enhanced UI and advanced search functionality.
 */

$tip_title = esc_html__('Developer Mode Enabled', 'redux-framework');

if ($this->parent->args_class->dev_mode_forced) {
	$is_debug     = Redux_Helpers::is_wp_debug();
	$is_localhost = Redux_Helpers::is_local_host();

	$debug_bit    = $is_debug ? esc_html__('WP_DEBUG is enabled', 'redux-framework') : '';
	$localhost_bit = $is_localhost ? esc_html__('you are working in a localhost environment', 'redux-framework') : '';
	$conjunction_bit = ($is_debug && $is_localhost) ? ' ' . esc_html__('and', 'redux-framework') . ' ' : '';

	$tip_msg = esc_html__('This has been automatically enabled because', 'redux-framework') . ' ' . $debug_bit . $conjunction_bit . $localhost_bit . '.';
} else {
	$tip_msg = esc_html__('If you are not a developer, your theme/plugin author shipped with developer mode enabled. Contact them directly to fix it.', 'redux-framework');
}

?>

<div id="redux-header" class="custom-redux-header">
	<?php if (! empty($this->parent->args['display_name'])) { ?>
		<div class="header-left">
			<img src="<?php echo esc_url($this->parent->args['logo_url']); ?>" alt="Logo" class="redux-logo" />
			<div>
				<?php if (! empty($this->parent->args['display_version'])) { ?>
					<span class="redux-version">(نسخه <?php echo wp_kses_post($this->parent->args['display_version']); ?>)</span>
				<?php } ?>
			</div>
		</div>
	<?php } ?>

	<div class="header-right">
		<div class="redux-search-container">
			<input type="text" id="redux-search" placeholder="<?php esc_html_e('Search settings...', BLOGINAC_TEXT_DOMAIN); ?>" />
		</div>
		<?php if (isset($this->parent->args['dev_mode']) && $this->parent->args['dev_mode']) { ?>
			<div
				class="redux-dev-mode-notice-container redux-dev-qtip"
				qtip-title="<?php echo esc_attr($tip_title); ?>"
				qtip-content="<?php echo esc_attr($tip_msg); ?>">
				<span class="redux-dev-mode-notice"> <?php esc_html_e('Developer Mode Enabled', 'redux-framework'); ?></span>
			</div>
		<?php } ?>
	</div>
</div>
<style>
	#redux-header {
		background: white !important;
		margin-bottom: 20px !important;
		background: linear-gradient(0.25turn, #537bff, #9c67ff) !important;
		border-color: white !important;
		box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1), 0px 1px 3px rgba(0, 0, 0, 0.06) !important;
	}
	.redux-version {
		color: white !important;
	}
</style>