<?php $price = BLOGINA_Course::get_price(true); ?>
<article id="post-<?php the_ID(); ?>" <?php post_class('blg-shadow-sm flex flex-col gap-y-5 rounded-[var(--blg-radius-3xl)] bg-white py-4 px-4 hover:border-t-2 hover:border-[var(--blg-color-secondary200)] transition-all duration-75'); ?>>
	<div class="flex flex-col gap-y-3">
		<a href="<?php the_permalink(); ?>" class="w-full">
			<header role="banner" class="entry-header">
				<div class="flex flex-col gap-y-3">
					<?php if (has_post_thumbnail()): ?>
						<div class="bg-[var(--blg-color-primary400)] !rounded-[20px] min-h-[212px]">
							<img width="100%" height="212" class="!rounded-[20px] w-full !h-[212px] object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>">
						</div>
					<?php else: ?>
						<div class="bg-[var(--blg-color-primary400)] !rounded-[20px] min-h-[212px]">
							<img width="100%" height="212" class="!rounded-[20px] w-full !h-[212px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="<?php the_title_attribute(); ?>">
						</div>
					<?php endif; ?>
					<?php if (BLOGINAC_Base::PTYPE_COURSE === get_post_type()): ?>
						<div class="w-full flex items-center justify-between">
							<div class="flex gap-x-1 items-center">
								<?php echo BLOGINA_User::get_avatar(get_the_ID(), 24, '', 'mentor'); ?>
								<span class="md:text-sm text-xs font-medium text-[var(--blg-color-primary)]"><?php echo BLOGINA_Course::get_mentor(); ?></span>
							</div>
							<?php echo BLOGINA_Course::get_rating(); ?>

						</div>
					<?php endif; ?>
					<div class="!flex !gap-x-1 !items-center">
						<svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
							<circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
						</svg>
						<h4 class="md:text-base text-[15px] font-bold text-[var(--blg-color-primary500)] blg-title-truncate"><?php the_title(); ?></h4>
					</div>
				</div>
			</header>
		</a>
		<div class="flex w-full gap-x-3">
			<?php
			echo BLOGINA_Post::tags(3, BLOGINAC_Base::TAX_COURSE_TAG);
			?>
		</div>
		<div class="flex gap-x-1 w-full items-center justify-end">
			<?php if ($price['sale_price']): ?>
				<div class="text-[var(--blg-gray)] font-medium md:text-[15px] text-[13px]">
					<del><?php echo $price['regular_price']; ?></del>
				</div>
				<div class="!w-[1px] h-[15px] bg-[var(--blg-color-primary500)] opacity-50 mx-1"></div>
				<div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo $price['sale_price']; ?></div>
			<?php else: ?>
				<div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]">
					<?php echo $price['regular_price']; ?>
				</div>
			<?php endif; ?>
			<div class="text-[#858585] text-[14px]"><?php echo BLOGINA_Course::get_currency(); ?></div>
		</div>
	</div>
</article>