<article id="post-<?php the_ID(); ?>" <?php post_class('blg-shadow-sm flex flex-col rounded-[var(--blg-radius-3xl)] bg-white py-6 px-6 hover:border-t-2 hover:border-[var(--blg-color-secondary200)] transition-all duration-75'); ?>>
	<div class="blg_filter_posts_form_message"></div>
	<div class="flex flex-col gap-y-3">
		<a href="<?php the_permalink(); ?>" class="w-full">

			<header role="banner" class="entry-header">
				<div class="flex flex-col gap-y-3">
					<?php if (has_post_thumbnail()): ?>
						<?php BLOGINA_POST::thumbnail(); ?>
					<?php else: ?>
						<img width="100%" height="220" class="!rounded-[20px] w-full !h-[220px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="<?php the_title_attribute(); ?>">
					<?php endif; ?>
					<div class="entry-categories">
						<?php BLOGINA_POST::categories(); ?>
					</div>

					<div class="!flex !gap-x-1 !items-center">
						<svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
							<circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
						</svg>
						<h4 class="md:text-base text-[15px] font-bold text-[var(--blg-color-primary500)] blg-title-truncate"><?php the_title(); ?></h4>
					</div>

					<p class="overflow-hidden text-right md:text-[15px] text-sm text-[var(--blg-gray)] font-normal"><?php echo wp_trim_words(get_the_excerpt(), 10, '...'); ?></p>
				</div>
			</header>
		</a>
		<?php if ('post' === get_post_type()): ?>
			<div class="w-full flex items-center justify-between">
				<div class="flex gap-x-1 items-center">
					<div class="bg-gray-300 rounded-full w-9 h-9">
						<?php
						$post_id = get_the_ID();
						echo BLOGINA_User::get_avatar($post_id, 36, 'rounded-full');
						?>
					</div>
					<span class="md:text-sm text-xs font-medium text-[var(--blg-color-primary500)]"><?php BLOGINA_POST::posted_by(); ?></span>
				</div>
				<div class="flex items-center gap-x-[2px]">
					<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
						<path d="M10.2698 18.4154C14.2537 18.4154 17.4834 15.1806 17.4834 11.1904C17.4834 7.20014 14.2537 3.96539 10.2698 3.96539C6.2858 3.96539 3.05615 7.20014 3.05615 11.1904C3.05615 15.1806 6.2858 18.4154 10.2698 18.4154Z" fill="var(--blg-color-primary400)" />
						<path d="M10.27 11.5404C9.92888 11.5404 9.646 11.2571 9.646 10.9154V6.74872C9.646 6.40705 9.92888 6.12372 10.27 6.12372C10.6111 6.12372 10.894 6.40705 10.894 6.74872V10.9154C10.894 11.2571 10.6111 11.5404 10.27 11.5404Z" fill="var(--blg-color-primary500)" />
						<path d="M12.6742 2.95705H7.86517C7.53236 2.95705 7.26611 2.69038 7.26611 2.35705C7.26611 2.02372 7.53236 1.74872 7.86517 1.74872H12.6742C13.0071 1.74872 13.2733 2.01538 13.2733 2.34872C13.2733 2.68205 13.0071 2.95705 12.6742 2.95705Z" fill="var(--blg-color-primary500)" />
					</svg>
					<div class="text-[var(--blg-color-primary300)] text-xs font-normal"><?php echo BLOGINA_ReadEstimateTime::blg_read_estimate_time(get_the_content()) . ' ' . __('minutes reading', BLOGINA_TEXT_DOMAIN); ?></div>
				</div>
			</div>
		<?php endif; ?>
	</div>
</article>