<article id="post-<?php the_ID(); ?>" <?php post_class('blg-shadow-sm h-full rounded-[var(--blg-radius-3xl)] bg-white'); ?>>
	<a href="<?php the_permalink(); ?>" aria-label="television link">
		<div class="relative w-full h-full lg:max-h-[280px] max-h-[260px] lg:min-h-[280px] min-h-[260px] !rounded-[32px]">
			<?php if (has_post_thumbnail()): ?>
				<img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>" alt="<?php the_title(); ?>" class="lg:max-h-[280px] max-h-[260px] lg:min-h-[280px] min-h-[260px] !rounded-[32px] w-full h-full object-cover cursor-pointer" />
			<?php else: ?>
				<img width="100%" height="300" class="!rounded-[var(--blg-radius-lg)] w-full lg:max-h-[280px] max-h-[260px] lg:min-h-[280px] min-h-[260px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="<?php the_title_attribute(); ?>">
			<?php endif; ?> 
			<button class="absolute rounded-[32px] inset-0 flex items-center justify-center w-full h-full bg-black bg-opacity-40">
				<svg class="bg-white p-[9px] rounded-lg lg:w-10 lg:h-10 w-8 h-8 transition duration-300 hover:fill-white hover:bg-[var(--blg-color-secondary200)]" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="currentColor">
					<path d="M6.16815 12.6368V15.3068C6.16815 18.6168 8.51815 19.9768 11.3881 18.3168L13.6981 16.9768L16.0081 15.6368C18.8781 13.9768 18.8781 11.2668 16.0081 9.60677L13.6981 8.26677L11.3881 6.92677C8.51815 5.29677 6.16815 6.64677 6.16815 9.96677V12.6368Z" />
				</svg>
			</button>
			<div class="flex flex-col items-start gap-y-2 absolute max-md:bottom-4 max-md:right-4 bottom-6 right-6">
				<div class="flex gap-x-1 items-center">
					<svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
						<circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
					</svg>
					<h4 class="md:text-base text-[15px] font-bold text-white blg-title-truncate"><?php the_title(); ?></h4>
				</div>
				<div class="flex items-center gap-x-1 bg-[#DBE3EA] rounded-lg py-1 px-2">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
						<path d="M18.5165 19.7606C17.9665 21.1706 16.6265 22.0806 15.1165 22.0806H9.21648C7.69648 22.0806 6.36648 21.1706 5.81648 19.7606C5.26648 18.3406 5.64648 16.7706 6.76648 15.7506L10.8165 12.0806H13.5265L17.5665 15.7506C18.6865 16.7706 19.0565 18.3406 18.5165 19.7606Z" fill="white" />
						<path d="M13.986 18.2206H10.346C9.96602 18.2206 9.66602 17.9106 9.66602 17.5406C9.66602 17.1606 9.97602 16.8606 10.346 16.8606H13.986C14.366 16.8606 14.666 17.1706 14.666 17.5406C14.666 17.9106 14.356 18.2206 13.986 18.2206Z" fill="var(--blg-color-primary500)" />
						<path d="M18.5157 4.40057C17.9657 2.99057 16.6257 2.08057 15.1157 2.08057H9.21569C7.70569 2.08057 6.36569 2.99057 5.81569 4.40057C5.27569 5.82057 5.64569 7.39057 6.77569 8.41057L10.8157 12.0806H13.5257L17.5657 8.41057C18.6857 7.39057 19.0557 5.82057 18.5157 4.40057ZM13.9857 7.31057H10.3457C9.96569 7.31057 9.66569 7.00057 9.66569 6.63057C9.66569 6.26057 9.97569 5.95057 10.3457 5.95057H13.9857C14.3657 5.95057 14.6657 6.26057 14.6657 6.63057C14.6657 7.00057 14.3557 7.31057 13.9857 7.31057Z" fill="var(--blg-color-primary500)" />
					</svg>
					<span class="text-xs font-normal"><?php echo BLOGINA_TELEVISION::get_television_video_time(); ?></span>
				</div>
			</div>
		</div>
	</a>
</article>
