<?php
// no direct access
defined('ABSPATH') || die();

if (is_user_logged_in()) return;

ob_start();
$assets = new BLOGINAC_Assets();
$assets->footer('<script>
    jQuery(document).ready(function()
    {
        jQuery("#blogina-register-form").bloginaRegisterForm({
            ajax_url: "' . admin_url('admin-ajax.php') . '",
            nonce: "' . wp_create_nonce('blg_register') . '"
        });
    });
    </script>');

$login_page = get_posts([
    'post_type' => 'page',
    'posts_per_page' => 1,
    's' => 'blogina-login',
]);

if (!empty($login_page)) $login_page_url = get_permalink($login_page[0]->ID);
else $login_page_url = wp_login_url();

$display_image_section = BLOGINAC_Settings::get('blg_display_logister_image');
?>
<div class="xl:w-9/12 max-w-[997px] h-full w-full mx-auto bg-white blg-shadow-sm rounded-[var(--blg-radius-3xl)] py-8 md:px-8 px-4 my-2">
    <div class="grid lg:grid-cols-8 grid-cols-1 gap-x-[55px]">
        <div class="<?php echo $display_image_section ? 'col-span-4':'col-span-8'; ?>" id="blg_register_wrapper">
            <form id="blogina-register-form" class="flex flex-col gap-y-2 h-full justify-between">
                <div id="blg_register_form_message"></div> 
                <div class="flex flex-col gap-y-6">
                    <div class="w-full py-2">
                        <div class="flex justify-between items-center">
                            <div class="flex flex-col gap-y-2">
                                <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php _e('Registration in Site', BLOGINAC_TEXT_DOMAIN); ?></h3>
                                <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                                    <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-[var(--blg-color-primary500)] text-[15px] font-semibold">لطفا برای عضویت در پورتال و خرید اطلاعات این فرم را تکمیل کنید.</div>

                    <div class="form-group flex flex-col gap-y-2">
                        <?php
                        echo BLOGINAC_Form::label([
                            'for' => 'blg_username',
                            'required' => true,
                            'title' => 'نام کاربری یا ایمیل',
                            'class' => 'font-[YekanBakh] text-[15px] text-[var(--blg-gray)]',
                        ]);
                        ?>
                        <div class="relative flex items-center">
                            <span class="absolute !left-3 top-1/2 transform -translate-y-1/2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                                    <path opacity="0.4" d="M2 13.0415V7.0615C2 4.3015 4.24 2.0715 7 2.0715H17C19.76 2.0715 22 4.3015 22 7.0615V14.0415C22 16.7915 19.76 19.0215 17 19.0215H15.5C15.19 19.0215 14.89 19.1715 14.7 19.4215L13.2 21.4115C12.54 22.2915 11.46 22.2915 10.8 21.4115L9.3 19.4215C9.14 19.2015 8.78 19.0215 8.5 19.0215H7C4.24 19.0215 2 16.7915 2 14.0415V13.0415Z" fill="var(--blg-color-primary500)" />
                                    <path d="M12 12.0715C11.44 12.0715 11 11.6215 11 11.0715C11 10.5215 11.45 10.0715 12 10.0715C12.55 10.0715 13 10.5215 13 11.0715C13 11.6215 12.56 12.0715 12 12.0715Z" fill="var(--blg-color-primary500)" />
                                    <path d="M16 12.0715C15.44 12.0715 15 11.6215 15 11.0715C15 10.5215 15.45 10.0715 16 10.0715C16.55 10.0715 17 10.5215 17 11.0715C17 11.6215 16.56 12.0715 16 12.0715Z" fill="var(--blg-color-primary500)" />
                                    <path d="M8 12.0715C7.44 12.0715 7 11.6215 7 11.0715C7 10.5215 7.45 10.0715 8 10.0715C8.55 10.0715 9 10.5215 9 11.0715C9 11.6215 8.56 12.0715 8 12.0715Z" fill="var(--blg-color-primary500)" />
                                </svg>
                            </span>

                            <?php echo BLOGINAC_Form::text([
                                'id' => 'blg_username',
                                'name' => 'blg_username',
                                'placeholder' => esc_html__('Username', BLOGINAC_TEXT_DOMAIN),
                                'class' => 'block font-[YekanBakh] text-[15px] rounded-[8px] text-[var(--blg-color-primary200)]',
                                'required' => true,
                            ]); ?>
                        </div>

                    </div>

                    <div class="form-group flex flex-col gap-y-2">
                        <?php
                        echo BLOGINAC_Form::label([
                            'for' => 'blg_tel',
                            'required' => true,
                            'title' => 'شماره تلفن',
                            'class' => 'font-[YekanBakh] text-[15px] text-[var(--blg-gray)]',
                        ]);
                        ?>
                        <div class="relative flex items-center">
                            <span class="absolute !left-3 top-1/2 transform -translate-y-1/2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                    <path opacity="0.4" d="M16.8972 2.16653H8.41723C5.65723 2.16653 4.65723 3.16653 4.65723 5.97653V18.3565C4.65723 21.1665 5.65723 22.1665 8.41723 22.1665H16.8872C19.6572 22.1665 20.6572 21.1665 20.6572 18.3565V5.97653C20.6572 3.16653 19.6572 2.16653 16.8972 2.16653Z" fill="var(--blg-color-primary500)" />
                                    <path d="M14.6572 6.41653H10.6572C10.2472 6.41653 9.90723 6.07653 9.90723 5.66653C9.90723 5.25653 10.2472 4.91653 10.6572 4.91653H14.6572C15.0672 4.91653 15.4072 5.25653 15.4072 5.66653C15.4072 6.07653 15.0672 6.41653 14.6572 6.41653Z" fill="var(--blg-color-primary500)" />
                                    <path d="M12.6572 19.4665C13.6237 19.4665 14.4072 18.683 14.4072 17.7165C14.4072 16.75 13.6237 15.9665 12.6572 15.9665C11.6907 15.9665 10.9072 16.75 10.9072 17.7165C10.9072 18.683 11.6907 19.4665 12.6572 19.4665Z" fill="var(--blg-color-primary500)" />
                                </svg>
                            </span>

                            <?php echo BLOGINAC_Form::tel([
                                'id' => 'blg_tel',
                                'name' => 'blg_tel',
                                'placeholder' => esc_html__('phone number', BLOGINAC_TEXT_DOMAIN),
                                'class' => 'block font-[YekanBakh] text-[15px] rounded-[8px] text-[var(--blg-color-primary200)] text-right',
                                'required' => true,
                            ]); ?>
                        </div>

                    </div>

                    <div class="form-group flex flex-col gap-y-2">
                        <?php
                        echo BLOGINAC_Form::label([
                            'for' => 'blg_password',
                            'required' => true,
                            'title' => 'رمز ورود',
                            'class' => 'font-[YekanBakh] text-[15px] text-[var(--blg-gray)]',
                        ]);
                        ?>
                        <div class="relative flex items-center">
                            <span id="toggle-password" class="toggle-icon absolute !left-3 top-1/2 transform -translate-y-1/2" onclick="togglePasswordVisibility('blg_password', this)">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="none">
                                    <path opacity="0.4" d="M21.7672 9.65012C21.2772 8.87012 20.7172 8.17012 20.1372 7.54012L16.3672 11.3101C16.4872 11.6801 16.5572 12.0801 16.5572 12.5001C16.5572 14.7401 14.7472 16.5401 12.5172 16.5401C12.0972 16.5401 11.6972 16.4701 11.3272 16.3501L7.86719 19.8101C9.32719 20.6301 10.9072 21.0601 12.5172 21.0601C14.2972 21.0601 16.0272 20.5401 17.6072 19.5701C19.1872 18.5901 20.6072 17.1601 21.7672 15.3401C22.7672 13.7801 22.7672 11.2201 21.7672 9.65012Z" fill="var(--blg-color-primary500)" />
                                    <path d="M14.5372 10.4801L10.4972 14.5201C9.98723 14.0001 9.65723 13.2801 9.65723 12.5001C9.65723 10.9301 10.9372 9.64012 12.5172 9.64012C13.2972 9.64012 14.0172 9.97012 14.5372 10.4801Z" fill="var(--blg-color-primary500)" />
                                    <path opacity="0.4" d="M18.7676 6.25011L15.3776 9.64011C14.6476 8.90012 13.6376 8.46011 12.5176 8.46011C10.2776 8.46011 8.47758 10.2701 8.47758 12.5001C8.47758 13.6201 8.92758 14.6301 9.65758 15.3601L6.27758 18.7501H6.26758C5.15758 17.8501 4.13758 16.7001 3.26758 15.3401C2.26758 13.7701 2.26758 11.2201 3.26758 9.65011C4.42758 7.83011 5.84758 6.40011 7.42758 5.42011C9.00758 4.46011 10.7376 3.93011 12.5176 3.93011C14.7476 3.93011 16.9076 4.75011 18.7676 6.25011Z" fill="var(--blg-color-primary500)" />
                                    <path d="M15.3777 12.5001C15.3777 14.0701 14.0977 15.3601 12.5177 15.3601C12.4577 15.3601 12.4077 15.3601 12.3477 15.3401L15.3577 12.3301C15.3777 12.3901 15.3777 12.4401 15.3777 12.5001Z" fill="var(--blg-color-primary500)" />
                                    <path d="M22.2875 2.73013C21.9875 2.43013 21.4975 2.43013 21.1975 2.73013L2.74746 21.1901C2.44746 21.4901 2.44746 21.9801 2.74746 22.2801C2.89746 22.4201 3.08746 22.5001 3.28746 22.5001C3.48746 22.5001 3.67746 22.4201 3.82746 22.2701L22.2875 3.81013C22.5975 3.51013 22.5975 3.03013 22.2875 2.73013Z" fill="var(--blg-color-primary500)" />
                                </svg>
                            </span>

                            <?php echo BLOGINAC_Form::input([
                                'id' => 'blg_password',
                                'name' => 'blg_password',
                                'placeholder' => esc_html__('password', BLOGINAC_TEXT_DOMAIN),
                                'class' => 'block font-[YekanBakh] text-[15px] rounded-[8px] text-[var(--blg-color-primary200)] text-right',
                                'required' => true,
                            ], 'password'); ?>
                        </div>

                    </div>

                </div>
                <div class="flex items-center justify-between text-nowrap mt-2">
                    <div class="flex items-center text-sm gap-x-2">
                        <input type="checkbox" id="blg_rules" name="agree_to_rules" class="block text-right" />
                        <?php
                        echo BLOGINAC_Form::label([
                            'for' => 'blg_rules',
                            'title' => 'موافقت با شرایط استفاده از خدمات',
                            'class' => 'font-[YekanBakh] text-[15px] text-[var(--blg-gray)]',
                        ]);
                        ?>
                    </div>
                </div>


                <div class="flex flex-col gap-y-1 md:!mt-10 md:my-0 my-8">
                    <div class="flex items-center gap-x-1">
                        <span class="text-[15px] text-[#818181] font-medium"><?php _e('Already Registered?', BLOGINAC_TEXT_DOMAIN); ?></span>
                        <a href="<?php echo esc_url($login_page_url); ?>" class="text-[15px] font-['YekanBakh'] text-[var(--blg-color-primary500)] font-medium !underline"><?php _e('ورود به سایت', BLOGINAC_TEXT_DOMAIN); ?></a>
                    </div>
                    <?php
                    echo BLOGINAC_Form::submit([
                        'label' => 'عضویت',
                        'id' => 'blogina-register-submit',
                        'class' => 'blg-btn-secondary w-max !p-1.5 flex gap-x-4 items-center',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"><path d="M15.1695 10.2244V12.4494C15.1695 15.2078 13.2112 16.3411 10.8195 14.9578L8.89453 13.8411L6.96953 12.7244C4.57786 11.3411 4.57786 9.08276 6.96953 7.69943L8.89453 6.58276L10.8195 5.46609C13.2112 4.10776 15.1695 5.23276 15.1695 7.99943V10.2244Z" fill="var(--blg-color-secondary200)" /></svg>',
                    ], 'submit');
                    ?>
                </div>
            </form>
        </div>
        <?php if($display_image_section) : ?>
            <div class="lg:flex hidden col-span-4 bg-[var(--blg-color-primary500)] w-full h-full !min-h-[620px] rounded-[var(--blg-radius-xl)] py-[280px] lg:px-[140px] px-[60px]">
                <img width="100%" height="100%" src="<?php echo BLOGINAC_Settings::get('blg_logister_logo')['url']; ?>" alt="">
            </div>
        <?php endif; ?>
    </div>
</div>
