<?php

namespace ElementorPro\Includes;

class ElementorCustomOptionHelper
{

    /**
    * Define all options as class properties
    */
    public static $default_values = [
        'jalali_date'=>false,
        'custom_templates' => true,
        'rtl_icons' => true,
        'anjoman_font' => false,
        'byekan_font' => false,
        'estedad_font' => false,
        'iransans_font'=> false,
        'iransansx_font'=> false,
        'iranyekan_font'=> false,
        'kara_font'=> false,
        'mikhak_font'=> false,
        'nahid_font'=> false,
        'parastoo_font'=> false,
        'pelak_font'=> false,
        'pinar_font'=> false,
        'sahel_font'=> false,
        'samim_font'=> false,
        'shabnam_font'=> false,
        'tanha_font'=> false,
        'vazir_font'=> false,
        'yekan_font'=> false
    ];


    /**
     * This method will convert checkbox options to boolean
     * Default is true
     * @param string $option_name  The option key
     * @return bool
    */
    public static function is_feature_enabled($option_name)
    {
        $option_value = get_option($option_name, self::$default_values[$option_name]);
        if (empty($option_value)) {
            return false;
        }

        return true;
    }


}