<?php

/**
 * The template for displaying archive pages for Course post type
 *
 * Template Name: Television Archive
 * 
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogina
 */

get_header(); 
do_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

$layout_type = BLOGINA_Settings::get('blg_archive_television_layout_type', 'grid');
$grid_columns = BLOGINA_Settings::get('blg_archive_television_grid_columns', 3);

?>

<div id="primary" class="content-area">
    <header class="page-header">
        <div class="w-full mb-6 mt-10 flex items-center justify-between">
            <div class="flex justify-between items-center">
                <div class="flex flex-col gap-y-2">
                    <h1 class="page-title text-xl font-bold text-[var(--blg-color-primary500)]"><?php post_type_archive_title(); ?></h1>
                    <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                        <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                    </div>
                </div>
            </div>
            <div class="flex items-center justify-center">
                <?php
                echo BLOGINAC_Form::select([
                    'name' => 'television-filter-bar',
                    'id' => 'television-filter-bar',
                    'class' => 'television-filter-bar rounded-lg !px-8 py-2',
                    'options' => [
                        'visits' => esc_html__('Most Visits', BLOGINA_TEXT_DOMAIN),
                        'newest' => esc_html__('Newest', BLOGINA_TEXT_DOMAIN),
                    ]
                ]);
                $assets = new BLOGINAC_Assets();
                $assets->footer('<script>
                        jQuery(document).ready(function() {
                            jQuery(".television-filter-bar").bloginaTelevisionFilterBar({
                                ajax_url: "' . admin_url('admin-ajax.php') . '",
                                nonce: "' . wp_create_nonce('lsd_television_filter_bar_nonce') . '",
                            });
                        });
                    </script>');
                ?>
            </div>
        </div>
    </header>
    <div class="grid grid-cols-12 gap-x-6 py-4 gap-y-4">
        <div class="lg:col-span-3 col-span-12">
            <?php get_sidebar(); ?>
        </div>
        <div class="lg:col-span-9 col-span-12 blg-post-content">
                <?php if ($layout_type === 'grid') : ?>
                        <div class="grid lg:grid-cols-<?php echo esc_attr($grid_columns); ?> md:grid-cols-2 grid-cols-1 gap-y-6 gap-x-6">
                <?php else : ?>
                    <div class="space-y-6">
                <?php endif; ?>
                <?php
                if (have_posts()):
                    /* Start the Loop */
                    while (have_posts()) {
                        the_post();

                        /*
						 * Include the Post-Type-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
						 */
                        get_template_part('templates/content', get_post_type());
                    }

                else:

                    get_template_part('templates/content', 'none');

                endif;
                ?>
            </div>
            <?php echo BLOGINA_Pagination::paginate($wp_query); ?>
        </div>
    </div>
</div>

<?php
get_footer();
