<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogina
 */

get_header();
do_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

$layout_type = BLOGINA_Settings::get('blg_archive_layout_type', 'grid');
$grid_columns = BLOGINA_Settings::get('blg_archive_grid_columns', 3);

?>
<div id="content" class="site-content">
    <?php if (is_home() && !is_front_page()): ?>
        <header role="banner">
            <div class="w-full mb-6 mt-10">
                <div class="flex justify-between items-center">
                    <div class="flex flex-col gap-y-2">
                        <h1 class="text-xl font-bold text-[var(--blg-color-primary500)]">
                            <?php single_post_title(); ?>
                        </h1>
                        <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                            <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
    <?php endif; ?>

    <div class="grid grid-cols-12 gap-x-6 py-4 gap-y-4">
        <?php $sidebar = BLOGINA_Settings::get('blg_archive_post_layout'); ?>
        
        <?php if ($sidebar != 'full-width') : ?>
            <div class="lg:col-span-3 <?php echo ($sidebar == 'sidebar-left') ? 'order-1':''; ?> col-span-12">
                <?php get_sidebar(); ?>
            </div>
        <?php endif; ?>

        <div class="<?php echo ($sidebar != 'full-width') ? 'lg:col-span-9' : ''; ?> col-span-12 blg-post-content">
            <?php if ($layout_type === 'grid') : ?>
                <div class="grid lg:grid-cols-<?php echo esc_attr($grid_columns); ?> md:grid-cols-2 grid-cols-1 gap-y-6 gap-x-6">
            <?php else : ?>
                <div class="space-y-6">
            <?php endif; ?>
            <?php
                if (have_posts()):
                    /* Start the Loop */
                    while (have_posts()) {
                        the_post();
                        get_template_part('templates/content', get_post_type());
                    }
                else:
                    get_template_part('templates/content', 'none');
                endif;
                wp_reset_postdata();

            ?>
            </div>
            <?php echo BLOGINA_Pagination::paginate($wp_query); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
