<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Blogina
 */
get_header();
do_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

?>

<div id="content" class="site-content">
	<div class="row">
		<div class="col-lg-12">
			<main role="main">
				<?php
				while (have_posts()) {
					the_post();

					get_template_part('templates/content', get_post_type());

					// If comments are open, or we have at least one comment, load up the comment template.
					if (comments_open() || get_comments_number()) {
						comments_template();
					}
				}
				?>
			</main>
		</div>
	</div>
    <?php if (BLOGINA_Settings::get('blg_single_television_show_related_posts')) : ?>
        <div class="blg-recent">
            <div class="w-full mb-6 mt-10">
                <div class="flex justify-between items-center">
                    <div class="flex flex-col gap-y-2">
                        <h4 class="lg:text-lg text-md font-bold text-[var(--blg-color-primary500)]">
                            <?php echo esc_html__('Recent Videos', BLOGINA_TEXT_DOMAIN); ?>
                        </h4>
                        <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                            <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo do_shortcode('[blogina-recent-posts post_type="blogina-television" number="4" orderby="date" order="DESC"]'); ?>
        </div>
    <?php endif; ?>
</div>
<?php
get_footer();
