<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
$sessions = BLOGINA_Course::get_sessions();
$view_mode = BLOGINA_Course::get_view_type();
$watch_type = BLOGINA_Course::get_watch_type();

?>
<?php if (is_array($sessions) && isset($sessions) && !empty($sessions)): ?>
    <div class="grid grid-cols-1">
        <div class="bg-white gap-x-8 gap-y-2 p-6 my-10 blg-shadow-sm rounded-[var(--blg-radius-3xl)] overflow-hidden">
            <div class="flex justify-between items-center my-4">
                <div class="flex flex-col gap-y-2">
                    <h2 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Course Sessions', BLOGINA_TEXT_DOMAIN); ?></h2>
                    <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                        <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                    </div>
                </div>
            </div>

            <!-- blg-Accordion Start -->
            <?php foreach ($sessions as $key => $session): ?>
                <div class="blg-accordion flex flex-col gap-y-2 mt-6">
                    <div class="blg-accordion-item bg-[var(--blg-color-primary100)] rounded-2xl">
                        <h3 class="blg-accordion-header">
                            <button aria-label="chapter title"
                                    class="blg-accordion-button flex justify-between rounded-none items-center w-full py-5 px-5 text-[var(--blg-color-primary500)] font-normal text-[15px] transition-all duration-300"
                                    type="button"
                                    data-target="#blg-accordion-item-sessions-<?php echo $key; ?>"
                                    aria-expanded="false">
                                <?php echo esc_html($session['chapter_title']); ?>
                                <span class="blg-accordion-icon text-3xl">+</span>
                            </button>
                        </h3>
                        <div id="blg-accordion-item-sessions-<?php echo $key; ?>"
                             class="blg-accordion-content border-t border-[var(--blg-color-primary400)] hidden px-4 py-4 text-[var(--blg-gray)] font-normal text-[15px]">
                            <?php if (!empty($session['sessions'])): ?>
                                <?php foreach ($session['sessions'] as $s): ?>
                                    <div class="blg-session flex flex-col gap-y-2">
                                        <div class="flex md:flex-row flex-col md:items-center items-start md:gap-y-0 gap-y-2 justify-between py-2">
                                            <div class="flex gap-x-2 items-center">
                                                <?php if ($s['status'] === 'free' || BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)): ?>
                                                    <div class="bg-[var(--blg-color-primary500)] rounded-lg flex items-center justify-center p-3 w-12">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="25"
                                                             height="25" viewBox="0 0 25 25" fill="none">
                                                            <path opacity="0.4"
                                                                  d="M12.254 17.3743C13.1542 17.3743 13.884 16.6445 13.884 15.7443C13.884 14.844 13.1542 14.1143 12.254 14.1143C11.3538 14.1143 10.624 14.844 10.624 15.7443C10.624 16.6445 11.3538 17.3743 12.254 17.3743Z"
                                                                  fill="white" />
                                                            <path d="M16.9039 9.46436H7.60391C3.50391 9.46436 2.25391 10.7144 2.25391 14.8144V16.6744C2.25391 20.7744 3.50391 22.0244 7.60391 22.0244H16.9039C21.0039 22.0244 22.2539 20.7744 22.2539 16.6744V14.8144C22.2539 10.7144 21.0039 9.46436 16.9039 9.46436ZM12.2539 18.7644C10.5839 18.7644 9.23391 17.4044 9.23391 15.7444C9.23391 14.0844 10.5839 12.7244 12.2539 12.7244C13.9239 12.7244 15.2739 14.0844 15.2739 15.7444C15.2739 17.4044 13.9239 18.7644 12.2539 18.7644Z"
                                                                  fill="white" />
                                                            <path opacity="0.4"
                                                                  d="M7.37363 9.47441V8.30441C7.37363 5.37441 8.20363 3.42441 12.2536 3.42441C16.5836 3.42441 17.1336 4.84684 17.1336 6.52748C17.1336 6.91748 17.4436 7.22594 17.8336 7.22594C18.2236 7.22594 18.5336 7.01763 18.5336 6.62763C18.5336 3.57823 16.4236 2.02441 12.2536 2.02441C6.62363 2.02441 5.97363 5.60441 5.97363 8.30441V9.55441C6.39363 9.50441 6.86363 9.47441 7.37363 9.47441Z"
                                                                  fill="white" />
                                                        </svg>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="bg-[var(--blg-color-primary400)] rounded-lg flex items-center justify-center p-3 w-12">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="25"
                                                             height="25" viewBox="0 0 25 25" fill="none">
                                                            <path opacity="0.4"
                                                                  d="M12.254 17.3743C13.1542 17.3743 13.884 16.6445 13.884 15.7443C13.884 14.844 13.1542 14.1143 12.254 14.1143C11.3538 14.1143 10.624 14.844 10.624 15.7443C10.624 16.6445 11.3538 17.3743 12.254 17.3743Z"
                                                                  fill="#3A4654" />
                                                            <path d="M16.9039 9.46436H7.60391C3.50391 9.46436 2.25391 10.7144 2.25391 14.8144V16.6744C2.25391 20.7744 3.50391 22.0244 7.60391 22.0244H16.9039C21.0039 22.0244 22.2539 20.7744 22.2539 16.6744V14.8144C22.2539 10.7144 21.0039 9.46436 16.9039 9.46436ZM12.2539 18.7644C10.5839 18.7644 9.23391 17.4044 9.23391 15.7444C9.23391 14.0844 10.5839 12.7244 12.2539 12.7244C13.9239 12.7244 15.2739 14.0844 15.2739 15.7444C15.2739 17.4044 13.9239 18.7644 12.2539 18.7644Z"
                                                                  fill="#3A4654" />
                                                            <path opacity="0.4"
                                                                  d="M7.37363 9.47441V8.30441C7.37363 5.37441 8.20363 3.42441 12.2536 3.42441C16.3036 3.42441 17.1336 5.37441 17.1336 8.30441V9.47441C17.6436 9.48441 18.1036 9.50441 18.5336 9.56441V8.30441C18.5336 5.60441 17.8836 2.02441 12.2536 2.02441C6.62363 2.02441 5.97363 5.60441 5.97363 8.30441V9.55441C6.39363 9.50441 6.86363 9.47441 7.37363 9.47441Z"
                                                                  fill="#3A4654" />
                                                        </svg>
                                                        </svg>
                                                    </div>
                                                <?php endif; ?>
                                                <h4 class="blg-session-title text-[var(--blg-gray)] text-[15px]"> <?php echo esc_html($s['title']); ?>
                                                </h4>
                                            </div>
                                            <div class="flex gap-x-2">
                                                <?php if($watch_type === 'video-download' || $watch_type === 'download'): ?>
                                                    <?php if ($s['status'] === 'free' || BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)): ?>
                                                        <a href="<?php echo esc_url($s['url']); ?>" class="download-btn border-2 border-[var(--blg-color-primary500)] text-[var(--blg-color-primary500)] flex items-center justify-center rounded-lg py-2 px-4">
                                                            <i class="fa fa-download"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                                <?php if(!BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id) && $s['status'] === 'locked'): ?>
                                                    <button
                                                            onclick="showToast('<?php echo esc_html__(__('You need to purchase the course first to view this content.', BLOGINA_TEXT_DOMAIN)); ?>', 'error')"
                                                            class="<?php echo ($s['status'] === 'locked' and !BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)) ? 'blg-btn-add-to-cart border border-[var(--blg-color-primary500)] text-[var(--blg-color-primary500)]' : 'bg-[var(--blg-color-primary500)] text-white'; ?> self-center flex justify-center !py-3 w-[152px] text-center !rounded-lg">
                                                        <?php echo ($s['status'] === 'locked' and !BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)) ? esc_html__('Register & View', BLOGINA_TEXT_DOMAIN) : esc_html__('View', BLOGINA_TEXT_DOMAIN); ?>

                                                    </button>
                                                <?php else: ?>
                                                    <?php if($watch_type === 'video-download' || $watch_type === 'video'): ?>
                                                        <button
                                                            <?php if ($view_mode === 'sessionmode'): ?>
                                                                data-view-mode="sessionmode"
                                                            <?php elseif ($view_mode === 'videomode'): ?>
                                                                onclick="video_modal('<?php echo esc_url($s['url']); ?>')"
                                                            <?php elseif ($view_mode === 'slidermode'): ?>
                                                                onclick="video_slider('<?php echo esc_url($s['url']); ?>', '<?php echo the_permalink(); ?>', '<?php echo the_title(); ?>')"
                                                            <?php endif; ?>
                                                            data-title="<?php echo esc_html($s['title']); ?>"
                                                            data-product-id="<?php echo esc_attr($post_id); ?>"
                                                            class="<?php echo $view_mode === 'chaptermode' ? 'view-modal-btn' : 'view-session-btn'; ?> <?php echo ($s['status'] === 'locked' and !BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)) ? 'blg-btn-add-to-cart border border-[var(--blg-color-primary500)] text-[var(--blg-color-primary500)]' : 'bg-[var(--blg-color-primary500)] text-white'; ?> self-center flex justify-center !py-3 w-[152px] text-center !rounded-lg">
                                                            <?php echo ($s['status'] === 'locked' and !BLOGINA_Course::has_user_purchased_product(get_current_user_id(), $post_id)) ? esc_html__('Register & View', BLOGINA_TEXT_DOMAIN) : esc_html__('View', BLOGINA_TEXT_DOMAIN); ?>
                                                        </button>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php if($view_mode ==='sessionmode'): ?>
                                            <div class="session-video-container hidden">
                                                <video class="plyr" width="100%" height="400" controls autoplay>
                                                    <source src="<?php echo esc_url($s['url']); ?>" type="video/mp4">
                                                    Your browser does not support the video tag.
                                                </video>
                                            </div>
                                        <?php endif; ?>
                                    </div>


                                <?php endforeach; ?>
                            <?php else: ?>
                                <p><?php esc_html_e('No sessions available for this chapter.', BLOGINA_TEXT_DOMAIN); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

        </div>
    </div>
    <?php
    if($view_mode === 'chaptermode')
        get_template_part('templates/single/course/chaptermode');
    ?>
<?php endif; ?>
