<?php
$display_tags = BLOGINA_Settings::get('blg_single_show_tags');
$display_categories = BLOGINA_Settings::get('blg_single_show_categories');
$display_share_icons = BLOGINA_Settings::get('blg_single_show_share_icons');
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('bg-white blg-shadow-sm rounded-[var(--blg-radius-3xl)] p-6 overflow-hidden'); ?>>
    <?php if (has_post_thumbnail()) : ?>
        <figure class="relative">
            <?php the_post_thumbnail('full', ['class' => 'w-full md:max-h-[428px] rounded-[20px] object-cover']); ?>
        </figure>
    <?php endif; ?>

    <div class="">
        <header class="my-4">
            <?php if ('post' === get_post_type() && BLOGINA_Settings::get('blg_single_show_posts_meta')): ?>
                <div class="flex md:gap-x-8 gap-x-2 items-center text-nowrap flex-wrap md:gap-y-0 gap-y-1">
                    <div class="flex gap-x-1 items-center">
                        <div class=" rounded-full md:w-7 md:h-7 w-6 h-6">
                            <?php
                            $post_id = get_the_ID();
                            echo BLOGINA_User::get_avatar($post_id, 28, 'rounded-full');
                            ?>
                        </div>
                        <span class="md:text-sm text-xs font-medium text-[#676767]"><?php BLOGINA_POST::posted_by(); ?></span>
                    </div>
                    <div class="flex gap-x-1 items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="23" viewBox="0 0 26 23" fill="none">
                            <path d="M19.1978 8.47908V6.79087C19.1978 5.74033 19.1978 5.21506 18.9731 4.81381C18.7755 4.46086 18.4602 4.1739 18.0724 3.99406C17.6315 3.78961 17.0543 3.78961 15.8999 3.78961H8.06742C6.91305 3.78961 6.33587 3.78961 5.89496 3.99406C5.50712 4.1739 5.1918 4.46086 4.99419 4.81381C4.76953 5.21506 4.76953 5.74033 4.76953 6.79087V16.9201L8.91109 15.0356M8.91109 15.0356C8.8919 14.7424 8.8919 14.3816 8.8919 13.9189V11.4803C8.8919 10.4298 8.8919 9.90453 9.11655 9.50328C9.31416 9.15033 9.62948 8.86337 10.0173 8.68353C10.4582 8.47908 11.0354 8.47908 12.1898 8.47908H17.9611C19.1155 8.47908 19.6927 8.47908 20.1336 8.68353C20.5214 8.86337 20.8367 9.15033 21.0343 9.50328C21.259 9.90453 21.259 10.4298 21.259 11.4803V18.7959L18.998 17.4242C18.6892 17.2368 18.5348 17.1432 18.3678 17.0768C18.2195 17.0179 18.0641 16.9751 17.9048 16.9492C17.7254 16.9201 17.5398 16.9201 17.1687 16.9201H12.1898C11.0354 16.9201 10.4582 16.9201 10.0173 16.7157C9.62948 16.5358 9.31416 16.2489 9.11655 15.8959C8.99085 15.6714 8.93548 15.4081 8.91109 15.0356Z" stroke="#BEBEBE" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="md:text-sm text-xs font-medium text-[#676767]">
                            <?php
                            echo BLOGINA_Post::get_comment_counts($post_id) . ' دیدگاه';
                            ?>
                        </span>
                    </div>
                    <div class="flex gap-x-1 items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="27" height="27" viewBox="0 0 27 27" fill="none">
                            <path d="M9.35547 2.20433V5.45433" stroke="#BEBEBE" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M18.0234 2.20433V5.45433" stroke="#BEBEBE" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.48047 9.88516H22.8971" stroke="#BEBEBE" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M23.4395 9.24599V18.4543C23.4395 21.7043 21.8145 23.871 18.0228 23.871H9.35612C5.56445 23.871 3.93945 21.7043 3.93945 18.4543V9.24599C3.93945 5.99599 5.56445 3.82932 9.35612 3.82932H18.0228C21.8145 3.82932 23.4395 5.99599 23.4395 9.24599Z" stroke="#BEBEBE" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M17.692 14.8793H17.7017" stroke="#BEBEBE" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M17.692 18.1293H17.7017" stroke="#BEBEBE" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.6842 14.8793H13.6939" stroke="#BEBEBE" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.6842 18.1293H13.6939" stroke="#BEBEBE" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.67634 14.8793H9.68607" stroke="#BEBEBE" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.67634 18.1293H9.68607" stroke="#BEBEBE" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="md:text-sm text-xs font-medium text-[#676767]"><?php BLOGINA_Post::posted_on(); ?></span>
                    </div>
                </div>
            <?php endif; ?>
        </header>

        <div class="entry-content blg-single-entry-content my-10">
            <?php
            the_content(sprintf(
                wp_kses(__('Continue reading<span class="screen-reader-text"> "%s"</span>', BLOGINA_TEXT_DOMAIN), array(
                    'span' => array(
                        'class' => [],
                    ),
                )),
                wp_kses_post(get_the_title())
            ));

            ?>
        </div>

        <!-- Categories -->
        <?php if($display_categories): ?>
            <div class="flex items-center gap-x-2 my-2">
                <h3 class="!text-[15px] !font-medium "><?php esc_html_e('Categories:', BLOGINA_TEXT_DOMAIN); ?></h3>
                <div class="text-gray-500 text-sm ">
                    <?php echo BLOGINA_Post::categories(); ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if($display_tags || $display_share_icons) : ?>
            <footer class="entry-footer border-t border-gray-200 pt-4 my-2 flex gap-y-8 flex-col">

                <?php echo $display_tags ? BLOGINA_Post::footer() : ''; ?>

                <?php if ($display_share_icons): ?>
                    <!-- Share Buttons -->
                    <div class=" flex items-center justify-between">
                        <h3 class=" font-medium "><?php echo esc_html__('Share', BLOGINA_TEXT_DOMAIN); ?></h3>
                        <div class="flex gap-x-4">
                            <a href="https://t.me/share/url?url=<?php echo urlencode(get_permalink()); ?>" class="flex items-center gap-x-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                    <path d="M9.83333 15.7043H6.83333V10.8709H6.19999C5.81333 10.8709 5.5 10.5576 5.5 10.1709V8.90426C5.5 8.51759 5.81333 8.20426 6.19999 8.20426H6.83333V6.5376C6.83333 5.1576 7.95333 4.0376 9.33333 4.0376H11.1333C11.52 4.0376 11.8333 4.35092 11.8333 4.73759V6.33761C11.8333 6.72427 11.52 7.0376 11.1333 7.0376H9.83333V8.20426H11.0867C11.3 8.20426 11.4933 8.2976 11.6267 8.4576C11.76 8.6176 11.8133 8.83093 11.7733 9.0376L11.52 10.3043C11.4533 10.6309 11.1667 10.8643 10.8333 10.8643H9.83333V15.7043ZM7.83333 14.7043H8.83333V9.87093H10.5933L10.7267 9.20426H8.84001V6.73759C8.84001 6.35092 9.15333 6.0376 9.54 6.0376H10.84V5.0376H9.33333C8.50667 5.0376 7.83333 5.71093 7.83333 6.5376V9.20426H6.5V9.87093H7.83333V14.7043Z" fill="var(--blg-color-secondary200)" />
                                    <path d="M10.0007 15.7043H6.00065C2.38065 15.7043 0.833984 14.1576 0.833984 10.5376V6.53764C0.833984 2.91764 2.38065 1.37097 6.00065 1.37097H10.0007C13.6207 1.37097 15.1673 2.91764 15.1673 6.53764V10.5376C15.1673 14.1576 13.6207 15.7043 10.0007 15.7043ZM6.00065 2.37097C2.92732 2.37097 1.83398 3.4643 1.83398 6.53764V10.5376C1.83398 13.611 2.92732 14.7043 6.00065 14.7043H10.0007C13.074 14.7043 14.1673 13.611 14.1673 10.5376V6.53764C14.1673 3.4643 13.074 2.37097 10.0007 2.37097H6.00065Z" fill="var(--blg-color-secondary200)" />
                                </svg>
                                <span class="text-[var(--blg-color-primary200)] text-xs font-semibold font-['Pinar']">تلگرام</span>
                            </a>
                            <a href="https://www.instagram.com/" class="flex items-center gap-x-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                    <path d="M10.0007 15.7043H6.00065C2.38065 15.7043 0.833984 14.1576 0.833984 10.5376V6.53764C0.833984 2.91764 2.38065 1.37097 6.00065 1.37097H10.0007C13.6207 1.37097 15.1673 2.91764 15.1673 6.53764V10.5376C15.1673 14.1576 13.6207 15.7043 10.0007 15.7043ZM6.00065 2.37097C2.92732 2.37097 1.83398 3.4643 1.83398 6.53764V10.5376C1.83398 13.611 2.92732 14.7043 6.00065 14.7043H10.0007C13.074 14.7043 14.1673 13.611 14.1673 10.5376V6.53764C14.1673 3.4643 13.074 2.37097 10.0007 2.37097H6.00065Z" fill="var(--blg-color-secondary200)" />
                                    <path d="M7.99935 11.3709C6.43935 11.3709 5.16602 10.0976 5.16602 8.53756C5.16602 6.97756 6.43935 5.70422 7.99935 5.70422C9.55935 5.70422 10.8327 6.97756 10.8327 8.53756C10.8327 10.0976 9.55935 11.3709 7.99935 11.3709ZM7.99935 6.70422C6.98602 6.70422 6.16602 7.52422 6.16602 8.53756C6.16602 9.55089 6.98602 10.3709 7.99935 10.3709C9.01268 10.3709 9.83268 9.55089 9.83268 8.53756C9.83268 7.52422 9.01268 6.70422 7.99935 6.70422Z" fill="var(--blg-color-secondary200)" />
                                    <path d="M11.3327 5.53766C11.246 5.53766 11.1593 5.51766 11.0793 5.48432C10.9993 5.45099 10.926 5.40432 10.8593 5.34432C10.7993 5.27766 10.746 5.20432 10.7127 5.12432C10.6793 5.04432 10.666 4.95766 10.666 4.87099C10.666 4.78432 10.6793 4.69766 10.7127 4.61766C10.7527 4.53099 10.7993 4.46432 10.8593 4.39766C10.8927 4.37099 10.926 4.33766 10.9593 4.31766C10.9993 4.29099 11.0393 4.27099 11.0793 4.25766C11.1193 4.23766 11.1593 4.22432 11.206 4.21766C11.4193 4.17099 11.646 4.24432 11.806 4.39766C11.866 4.46432 11.9127 4.53099 11.946 4.61766C11.9793 4.69766 11.9993 4.78432 11.9993 4.87099C11.9993 4.95766 11.9793 5.04432 11.946 5.12432C11.9127 5.20432 11.866 5.27766 11.806 5.34432C11.7393 5.40432 11.666 5.45099 11.586 5.48432C11.506 5.51766 11.4193 5.53766 11.3327 5.53766Z" fill="var(--blg-color-secondary200)" />
                                </svg>
                                <span class="text-[var(--blg-color-primary200)] text-xs font-semibold font-['Pinar']">اینستاگرام</span>
                            </a>
                            <a href="https://wa.me/?text=<?php echo urlencode(get_permalink()); ?>" class="flex items-center gap-x-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                                    <path d="M1.33343 15.7043C1.20009 15.7043 1.07341 15.6509 0.980073 15.5576C0.853406 15.4309 0.800105 15.2443 0.846772 15.0709L1.68678 11.9309C1.12678 10.8909 0.833426 9.71759 0.833426 8.53092C0.833426 4.57759 4.04676 1.36426 8.00009 1.36426C11.9534 1.36426 15.1668 4.57759 15.1668 8.53092C15.1668 12.4843 11.9534 15.6976 8.00009 15.6976C6.79343 15.6976 5.61344 15.3976 4.56011 14.8243L1.46677 15.6843C1.4201 15.6976 1.38009 15.7043 1.33343 15.7043ZM4.62676 13.7909C4.71343 13.7909 4.8001 13.8176 4.8801 13.8576C5.8201 14.4109 6.90009 14.7043 8.00009 14.7043C11.4001 14.7043 14.1668 11.9376 14.1668 8.5376C14.1668 5.1376 11.4001 2.37093 8.00009 2.37093C4.60009 2.37093 1.83343 5.1376 1.83343 8.5376C1.83343 9.62426 2.12009 10.6843 2.66009 11.6176C2.72675 11.7309 2.74676 11.8709 2.71343 11.9976L2.04676 14.4909L4.50009 13.8109C4.54009 13.7976 4.58676 13.7909 4.62676 13.7909Z" fill="var(--blg-color-secondary200)" />
                                    <path d="M9.82682 12.3776C9.41349 12.3776 8.98683 12.2843 8.54016 12.091C8.12016 11.911 7.70016 11.671 7.2935 11.371C6.8935 11.0776 6.50018 10.7443 6.14018 10.3843C5.78018 10.0176 5.44682 9.63096 5.15348 9.23096C4.85348 8.81096 4.61348 8.39762 4.44014 7.99095C4.25348 7.55095 4.16016 7.11763 4.16016 6.70429C4.16016 6.41096 4.21348 6.13096 4.31348 5.87096C4.42014 5.59763 4.59348 5.35095 4.82015 5.13762C5.24682 4.71762 5.86018 4.5643 6.34684 4.79764C6.51351 4.87097 6.65351 4.99097 6.76017 5.15097L7.53349 6.23762C7.61349 6.34428 7.67351 6.45762 7.72017 6.57095C7.77351 6.70428 7.80684 6.83764 7.80684 6.9643C7.80684 7.13764 7.76016 7.31097 7.66683 7.4643C7.60683 7.5643 7.52015 7.6843 7.40682 7.79764L7.32015 7.89096C7.36015 7.94429 7.40681 8.01095 7.48014 8.09095C7.62014 8.25095 7.77348 8.42428 7.94015 8.59095C8.10681 8.75095 8.27348 8.91095 8.44015 9.05095C8.52014 9.11762 8.58684 9.17096 8.64018 9.20429L8.73348 9.11095C8.85348 8.99095 8.97351 8.89763 9.09351 8.83763C9.31351 8.69763 9.65349 8.6643 9.95349 8.79096C10.0602 8.83096 10.1668 8.89095 10.2802 8.97095L11.3935 9.75762C11.5468 9.86428 11.6668 10.011 11.7468 10.1776C11.8135 10.3443 11.8402 10.491 11.8402 10.6443C11.8402 10.8443 11.7935 11.0376 11.7068 11.2243C11.6202 11.3976 11.5201 11.551 11.4001 11.691C11.1868 11.9243 10.9402 12.0976 10.6735 12.211C10.4068 12.3243 10.1202 12.3776 9.82682 12.3776ZM5.86015 5.69762C5.82015 5.69762 5.68685 5.69762 5.52018 5.86429C5.39352 5.98429 5.30683 6.11096 5.24683 6.25096C5.18683 6.39096 5.16016 6.55097 5.16016 6.71097C5.16016 6.99097 5.22681 7.29095 5.36015 7.61095C5.50015 7.94428 5.70683 8.29763 5.96016 8.65097C6.22016 9.0043 6.5135 9.35763 6.84017 9.68429C7.16684 10.0043 7.51349 10.3043 7.87349 10.571C8.22016 10.8243 8.57351 11.0243 8.92684 11.1776C9.43351 11.3976 9.90015 11.451 10.2802 11.291C10.4135 11.2376 10.5335 11.1443 10.6535 11.0243C10.7135 10.9576 10.7602 10.891 10.8002 10.8043C10.8202 10.7576 10.8335 10.7043 10.8335 10.6576C10.8335 10.6443 10.8335 10.6243 10.8135 10.5843L9.70015 9.81096C9.65349 9.77763 9.60681 9.75095 9.56681 9.73762C9.54015 9.75095 9.50017 9.77095 9.42684 9.84429L9.1735 10.0976C8.98017 10.291 8.67351 10.3443 8.42684 10.2576L8.30684 10.2043C8.15351 10.1243 7.98016 10.0043 7.78682 9.83763C7.60016 9.67763 7.42018 9.51095 7.22685 9.32429C7.04018 9.13095 6.8735 8.95096 6.7135 8.76429C6.54017 8.55762 6.42017 8.39096 6.34017 8.25096L6.26685 8.07762C6.24685 8.01096 6.24015 7.93763 6.24015 7.87096C6.24015 7.68429 6.30685 7.51762 6.43351 7.38428L6.68685 7.1243C6.76018 7.05096 6.78684 7.01097 6.80017 6.9843C6.78017 6.93763 6.75351 6.89763 6.72017 6.85096L5.94014 5.75096L5.86015 5.69762Z" fill="var(--blg-color-secondary200)" />
                                </svg>
                                <span class="text-[var(--blg-color-primary200)] text-xs font-semibold font-['Pinar']">واتساپ</span>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </footer>
        <?php endif; ?>
    </div>
</article>
