<?php

/**
 * Custom Empty Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit; ?>

<div class="flex flex-col gap-y-4 items-center justify-center p-16 bg-[var(--blg-color-primary100)] rounded-[var(--blg-radius-3xl)]">
	<span>
		<svg width="160" height="161" viewBox="0 0 160 161" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path opacity="0.4" d="M107.934 59.289C105.334 59.289 103.267 57.2223 103.267 54.6223V46.089C103.267 39.5557 100.467 33.289 95.6671 28.889C90.7337 24.4223 84.4004 22.3557 77.7337 22.9557C66.5337 24.0223 56.7337 35.4223 56.7337 47.289V53.289C56.7337 55.889 54.6671 57.9557 52.0671 57.9557C49.4671 57.9557 47.4004 55.889 47.4004 53.289V47.289C47.4004 30.6223 60.8671 15.2223 76.8004 13.689C86.0671 12.8223 95.0004 15.7557 101.867 22.0223C108.667 28.1557 112.534 36.9557 112.534 46.089V54.6223C112.534 57.2223 110.467 59.289 107.934 59.289Z" fill="#3A4654" />
			<path d="M133.066 59.9554C127.466 53.7554 118.266 50.7554 104.8 50.7554H55.1996C41.7329 50.7554 32.5329 53.7554 26.9329 59.9554C20.4663 67.1554 20.6663 76.7554 21.3996 83.422L26.0663 120.555C27.4663 133.555 32.7329 146.889 61.3996 146.889H98.5996C127.266 146.889 132.533 133.555 133.933 120.622L138.6 83.3554C139.333 76.7554 139.533 67.1554 133.066 59.9554ZM79.9996 124.089C66.0663 124.089 54.7329 112.755 54.7329 98.822C54.7329 84.8887 66.0663 73.5554 79.9996 73.5554C93.9329 73.5554 105.266 84.8887 105.266 98.822C105.266 112.755 93.9329 124.089 79.9996 124.089Z" fill="#3A4654" />
			<path opacity="0.4" d="M79.9991 124.089C93.9535 124.089 105.266 112.777 105.266 98.8223C105.266 84.8679 93.9535 73.5557 79.9991 73.5557C66.0447 73.5557 54.7324 84.8679 54.7324 98.8223C54.7324 112.777 66.0447 124.089 79.9991 124.089Z" fill="#3A4654" />
			<path d="M90.6662 102.289L87.1328 98.7556L90.4661 95.4222C92.3995 93.4889 92.3995 90.2889 90.4661 88.3556C88.5328 86.4222 85.3328 86.4222 83.3995 88.3556L80.0661 91.6889L76.5328 88.1556C74.5995 86.2222 71.3995 86.2222 69.4661 88.1556C67.5328 90.0889 67.5328 93.2889 69.4661 95.2222L72.9995 98.7556L69.3328 102.422C67.3995 104.356 67.3995 107.556 69.3328 109.489C70.3328 110.489 71.5995 110.956 72.8661 110.956C74.1328 110.956 75.3995 110.489 76.3995 109.489L80.0661 105.822L83.5995 109.356C84.5995 110.356 85.8661 110.822 87.1328 110.822C88.3995 110.822 89.6662 110.356 90.6662 109.356C92.5995 107.422 92.5995 104.289 90.6662 102.289Z" fill="#3A4654" />
		</svg>
	</span>
	<h2 class="text-2xl font-bold text-gray-800 mb-4"><?php esc_html_e('Your Cart is Empty', BLOGINA_TEXT_DOMAIN); ?></h2>
	<a href="<?php echo esc_url(wc_get_page_permalink('shop')); ?>" class="inline-block px-6 py-2 bg-[var(--blg-color-secondary200)] text-white font-semibold rounded blg-btn-secondary">
		<?php esc_html_e('Go to Shop', BLOGINA_TEXT_DOMAIN); ?>
	</a>
</div>