<?php

/**
 * Shipping Methods Display
 *
 * In 2.1 we show methods per package. This allows for multiple methods per order if so desired.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-shipping.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.8.0
 */

defined('ABSPATH') || exit;

$formatted_destination = isset($package['destination'], $package['destination']['state']) ? WC()->countries->states[$package['destination']['country']][$package['destination']['state']] : '';
$has_calculated_shipping  = ! empty($has_calculated_shipping);
$show_shipping_calculator = ! empty($show_shipping_calculator);
$calculator_text          = '';
?>
<tr class="woocommerce-shipping-totals shipping">

    <td class="!border-none" data-title="<?php echo esc_attr($package_name); ?>">
        <div class="flex !justify-between items-center md:text-xl text-md font-semibold text-[var(--blg-color-primary500)]">

            <div class="flex gap-x-2 items-end">
                <span class="font-semibold md:text-base text-[15px] !border-none text-[var(--blg-gray)]v text-nowrap">
                    <?php echo wp_kses_post($package_name); ?>
                </span>
                <div class="xl:flex hidden">
                    <?php if (! empty($available_methods) && is_array($available_methods)) : ?>

                        <?php if (is_cart() || is_checkout()) : ?>
                            <p class="woocommerce-shipping-destination text-[var(--blg-gray)] font-semibold">
                                <?php
                                if ($formatted_destination) {
                                    // Translators: $s shipping destination.
                                    echo '(';
                                    printf(esc_html__('Shipping to %s', BLOGINA_TEXT_DOMAIN) . ' ', esc_html($formatted_destination));
                                    echo ')';
                                    $calculator_text = esc_html__('Change address', 'woocommerce');
                                } else {
                                    echo '<span class="woocommerce-checkout-long-text">' . wp_kses_post(apply_filters('woocommerce_shipping_estimate_html', __('Shipping options will be updated during checkout.', 'woocommerce'))) . '</span>';
                                }
                                ?>
                            </p>
                        <?php endif; ?>
                    <?php
                    elseif (! $has_calculated_shipping || ! $formatted_destination) :
                        if (is_cart() && 'no' === get_option('woocommerce_enable_shipping_calc')) {
                            echo '<span class="woocommerce-checkout-long-text">' . wp_kses_post(apply_filters('woocommerce_shipping_not_enabled_on_cart_html', __('Shipping costs are calculated during checkout.', 'woocommerce'))) . '</span>';
                        } else {
                            echo '<span class="woocommerce-checkout-long-text">' . wp_kses_post(apply_filters('woocommerce_shipping_may_be_available_html', __('Enter your address to view shipping options.', 'woocommerce'))) . '</span>';
                        }
                    elseif (! is_cart()) :
                        echo '<span class="woocommerce-checkout-long-text">' . wp_kses_post(apply_filters('woocommerce_no_shipping_available_html', __('There are no shipping options available. Please ensure that your address has been entered correctly, or contact us if you need any help.', 'woocommerce'))) . '</span>';
                    else :
                        echo '<span class="woocommerce-checkout-long-text">' . wp_kses_post(
                            /**
                             * Provides a means of overriding the default 'no shipping available' HTML string.
                             *
                             * @since 3.0.0
                             *
                             * @param string $html                  HTML message.
                             * @param string $formatted_destination The formatted shipping destination.
                             */
                            apply_filters(
                                'woocommerce_cart_no_shipping_available_html',
                                // Translators: $s shipping destination.
                                sprintf(esc_html__('No shipping options were found for %s.', 'woocommerce') . ' ', '<strong>' . esc_html($formatted_destination) . '</strong>'),
                                $formatted_destination
                            )
                        ) . '</span>';
                        $calculator_text = esc_html__('Enter a different address', 'woocommerce');
                    endif;
                    ?>
                </div>
                <?php if ($show_shipping_calculator) : ?>
                    <?php printf('<a href="#" class="shipping-calculator-button text-nowrap">%s</a>', esc_html(! empty($calculator_text) ? $calculator_text : __('Calculate shipping', 'woocommerce'))); ?>
                <?php endif; ?>
            </div>
            <div>

                <?php if ($show_package_details) : ?>
                    <?php echo '<p class="woocommerce-shipping-contents"><small>' . esc_html($package_details) . '</small></p>'; ?>
                <?php endif; ?>
            </div>

        </div>
    </td>
</tr>
<tr>
    <td colspan="2" class="!border-none !p-0 !py-4">
        <?php if (!empty($available_methods)) : ?>
            <div class="woocommerce-shipping-price text-right flex items-start flex-col gap-y-4">
                <?php $i = 0; ?>
                <?php foreach ($available_methods as $method_id => $method) : ?>
                    <div class="flex items-center gap-x-2 text-right justify-start bg-[var(--blg-color-primary100)] p-2 w-full rounded-lg">
                        <input type="radio"
                            name="shipping_method[<?php echo esc_attr($i); ?>]"
                            id="shipping_method_<?php echo esc_attr($i . '_' . sanitize_title($method_id)); ?>"
                            value="<?php echo esc_attr($method_id); ?>"
                            <?php checked($chosen_method, $method_id); ?>
                            class="shipping_method border-none shadow-none !w-auto">
                        <label class="!flex !items-center !justify-between w-full" for="shipping_method_<?php echo esc_attr($i . '_' . sanitize_title($method_id)); ?>">
                            <span class="text-nowrap font-semibold font-['YekanBakh'] text-[var(--blg-gray)]"><?php echo esc_html($method->get_label()); ?></span>
                            <span class="text-nowrap text-[var(--blg-color-primary500)] font-medium"><?php echo wc_price($method->get_cost()); ?></span>
                        </label>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </td>
</tr>

<tr>
    <td colspan="2">
        <?php woocommerce_shipping_calculator($calculator_text); ?>
    </td>
</tr>