<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_cart'); ?>

<form class="woocommerce-cart-form flex flex-col gap-y-8" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
	<?php do_action('woocommerce_before_cart_table'); ?>

	<div class="woocommerce-cart cart woocommerce-cart-form__contents">
		<div class="woocommerce-cart-items flex flex-col gap-y-6 blg-shadow-sm bg-white md:px-8 px-2 md:py-8 py-2 rounded-[var(--blg-radius-3xl)]">
			<?php do_action('woocommerce_before_cart_contents'); ?>

			<?php
			foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
				$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
				$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

				if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
					$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
			?>
					<div class="woocommerce-cart-item rounded-[var(--blg-radius-2xl)] flex md:flex-row flex-wrap flex-col md:items-center lg:gap-x-[40px] 3xl:gap-x-[80px] gap-x-2 gap-y-4 border-b bg-[var(--blg-color-primary100)] p-4">
						<div class="flex items-center gap-x-2">
							<div class="product-thumbnail w-[86px] h-[86px]">
								<?php
								$thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
								if (!$product_permalink) echo $thumbnail;
								else printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail);
								?>
							</div>

							<div class="flex flex-col gap-y-2">
								<div class="product-title font-bold text-[var(--blg-color-primary500)]">
									<?php
									if (!$product_permalink) echo wp_kses_post($_product->get_name());
									else echo wp_kses_post(sprintf('<a href="%s" class="">%s</a>', esc_url($product_permalink), $_product->get_name()));
									?>
								</div>

								<div class="product-category text-[var(--blg-gray)] font-medium">
									<?php echo wp_kses_post(implode(', ', wp_list_pluck(get_the_terms($product_id, 'product_cat'), 'name'))); ?>
								</div>
							</div>
						</div>
						<div class="w-[1px] opacity-10 h-16 bg-[var(--blg-color-primary500)] md:flex hidden"></div>

						<div class="product-price flex md:flex-col max-md:gap-x-2 md:gap-y-2">
							<h4 class="font-bold text-[var(--blg-color-primary500)]"><?php echo esc_html__('Price:', BLOGINA_TEXT_DOMAIN); ?></h4>
							<span class="text-[var(--blg-gray)] font-medium">
								<?php echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); ?>
							</span>
						</div>
						<div class="w-[1px] opacity-10 h-16 bg-[var(--blg-color-primary500)] md:flex hidden"></div>

						<?php
						if ($_product->is_sold_individually()) {
							$min_quantity = 1;
							$max_quantity = 1;
						} else {
							$min_quantity = 0;
							$max_quantity = $_product->get_max_purchase_quantity();
						}

						$product_quantity = woocommerce_quantity_input(
							array(
								'input_name'   => "cart[{$cart_item_key}][qty]",
								'input_value'  => $cart_item['quantity'],
								'max_value'    => $max_quantity,
								'min_value'    => $min_quantity,
								'product_name' => $product_name,
							),
							$_product,
							false
						);

						echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
						?>

						<div class="w-[1px] opacity-10 h-16 bg-[var(--blg-color-primary500)] md:flex hidden"></div>
						<div class="product-subtotal flex md:flex-col max-md:gap-x-2 md:gap-y-2">
							<h4 class="font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Subtotal:', BLOGINA_TEXT_DOMAIN); ?></h4>
							<span class="text-[var(--blg-gray)] font-medium">
								<?php echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); ?>
							</span>
						</div>
						<div class="w-[1px] opacity-10 h-16 bg-[var(--blg-color-primary500)] md:flex hidden"></div>

						<div class="product-remove">
							<?php
							echo apply_filters(
								'woocommerce_cart_item_remove_link',
								sprintf(
									'<a href="%s" class="text-[var(--blg-color-primary500)] border rounded-lg text-base border-[var(--blg-color-primary500)] px-9 py-2" aria-label="%s" data-product_id="%s" data-product_sku="%s">%s</a>',
									esc_url(wc_get_cart_remove_url($cart_item_key)),
									esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($_product->get_name()))),
									esc_attr($product_id),
									esc_attr($_product->get_sku()),
									esc_html__('Remove', BLOGINA_TEXT_DOMAIN)
								),
								$cart_item_key
							);
							?>
						</div>
					</div>
			<?php
				}
			}
			?>
			<?php do_action('woocommerce_cart_contents'); ?>
			<button type="submit" class="!py-[14px] !rounded-[var(--blg-radius-lg)] !bg-[var(--blg-color-secondary200)] !font-semibold !text-white !max-w-max !self-end !px-9 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>
		</div>
	</div>
	<?php do_action('woocommerce_after_cart_table'); ?>


	<?php do_action('woocommerce_before_cart_collaterals'); ?>

	<div class="cart-collaterals grid lg:grid-cols-2 grid-cols-1 lg:gap-x-7 gap-y-7">
		<div class="actions col-span-1">

			<div class="flex gap-x-2 items-center w-full !h-max blg-shadow-sm bg-white md:px-6 px-4 md:py-6 py-6 rounded-[var(--blg-radius-3xl)]">

				<?php if (wc_coupons_enabled()) { ?>
					<div class="coupon w-full">
						<label for="coupon_code" class="screen-reader-text"><?php esc_html_e('Coupon:', 'woocommerce'); ?></label>
						<input type="text" name="coupon_code" class="input-text min-h-[48px] rounded-lg !px-4 !py-2" id="coupon_code" value="" placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>" />
						<?php do_action('woocommerce_cart_coupon'); ?>
					</div>
				<?php } ?>
				<button type="submit" class="!text-nowrap !bg-[var(--blg-color-primary500)] !text-white !px-4 !py-2 !rounded-lg button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?></button>
			</div>

			<?php do_action('woocommerce_cart_actions'); ?>

			<?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
		</div>
		<?php do_action('woocommerce_cart_collaterals'); ?>
	</div>

</form>


<?php do_action('woocommerce_after_cart'); ?>

<script>
	function updateQuantity(cartItemKey, change) {
		const inputField = document.querySelector(`input[name="cart[${cartItemKey}][qty]"]`);
		if (inputField) {
			let currentValue = parseInt(inputField.value) || 0;
			currentValue += change;

			// Prevent negative values
			if (currentValue < 0) {
				currentValue = 0;
			}

			inputField.value = currentValue;

			// Update the cart (you can choose to submit the form or use AJAX)
			const cartForm = document.querySelector('form.woocommerce-cart-form'); // Adjust the selector if necessary
			if (cartForm) {
				cartForm.submit(); // Submit the entire form
			}
		}
	}
</script>