<?php

/**
 * Mini-cart
 *
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_mini_cart'); ?>
<div id="mini-cart-sidebar" class="mini-cart-side">
    <div class="sidebar-content">
        <?php if (!WC()->cart->is_empty()) : ?>

            <ul class="woocommerce-mini-cart cart_list product_list_widget <?php echo esc_attr($args['list_class']); ?>">
                <?php
                do_action('woocommerce_before_mini_cart_contents');

                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                    $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                    $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

                    if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)) {
                        /**
                         * This filter is documented in woocommerce/templates/cart/cart.php.
                         *
                         * @since 2.1.0
                         */
                        $product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);
                        $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
                        $product_price = apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key);
                        $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                ?>
                        <li class="woocommerce-mini-cart-item mini_cart_item <?php echo esc_attr(apply_filters('woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key)); ?>">
                            <?php
                            echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                'woocommerce_cart_item_remove_link',
                                sprintf(
                                    '<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s" data-success_message="%s"><i class="fa fa-trash"></i></a>',
                                    esc_url(wc_get_cart_remove_url($cart_item_key)),
                                    /* translators: %s is the product name */
                                    esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
                                    esc_attr($product_id),
                                    esc_attr($cart_item_key),
                                    esc_attr($_product->get_sku()),
                                    /* translators: %s is the product name */
                                    esc_attr(sprintf(__('&ldquo;%s&rdquo; has been removed from your cart', 'woocommerce'), wp_strip_all_tags($product_name)))
                                ),
                                $cart_item_key
                            );
                            ?>
                            <?php if (empty($product_permalink)) : ?>
                                <div class="!flex flex-row items-center gap-x-2 cart-item-img-title">
                                    <?php echo $thumbnail; ?>
                                    <h4 class="text-[11px] text-[var(--blg-gray)]"><?php echo wp_kses_post($product_name); ?></h4>
                                </div>
                            <?php else : ?>
                                <a href="<?php echo esc_url($product_permalink); ?>" class="cart-item-img-title !flex flex-row items-center gap-x-2">
                                    <?php echo $thumbnail; ?>
                                    <h4 class="text-[11px] text-[var(--blg-gray)]"><?php echo wp_kses_post($product_name); ?></h4>
                                </a>
                            <?php endif; ?>

                            <div class="quantity-price" key="<?php echo $cart_item_key; ?>">

                                <?php if (is_cart() || is_checkout()) : ?>

                                <?php else : ?>
                                    <?php
                                    if ($_product->is_sold_individually()) {
                                        $min_quantity = 1;
                                        $max_quantity = 1;
                                    } else {
                                        $min_quantity = 0;
                                        $max_quantity = $_product->get_max_purchase_quantity();
                                    }

                                    $product_quantity = woocommerce_quantity_input(
                                        array(
                                            'input_name'   => "cart[{$cart_item_key}][qty]",
                                            'input_value'  => $cart_item['quantity'],
                                            'max_value'    => $max_quantity,
                                            'min_value'    => $min_quantity,
                                            'product_name' => $product_name,
                                        ),
                                        $_product,
                                        false
                                    );

                                    echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
                                    ?>
                                <?php endif; ?>

                                <span class="price" <?php echo (is_cart() || is_checkout()) ? 'style="display:flex !important;justify-content: end !important;width:100%;"' : ''; ?>>
                                    <span class="woocommerce-Price-amount amount">
                                        <bdi><?php echo wc_price($cart_item['line_total'] / $cart_item['quantity']); ?></bdi>
                                    </span>
                                </span>

                            </div>

                        </li>
                <?php
                    }
                }

                do_action('woocommerce_mini_cart_contents');
                ?>
            </ul>

            <div class="footer-mini-cart">
                <p class="woocommerce-mini-cart__total total flex flex-col gap-y-2">
                    <?php
                    /**
                     * Hook: woocommerce_widget_shopping_cart_total.
                     *
                     * @hooked woocommerce_widget_shopping_cart_subtotal - 10
                     */
                    do_action('woocommerce_widget_shopping_cart_total');
                    ?>
                </p>

                <?php do_action('woocommerce_widget_shopping_cart_before_buttons'); ?>

                <div class="woocommerce-mini-cart__buttons buttons">
                    <a href="<?php echo esc_url(wc_get_checkout_url()); ?>" class="button !px-6 !py-3 checkout wc-forward"><?php esc_html_e('Checkout', 'woocommerce'); ?></a>
                    <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="button !px-6 !py-3 checkout wc-forward"><?php esc_html_e('Cart', 'woocommerce'); ?></a>
                </div>

                <?php do_action('woocommerce_widget_shopping_cart_after_buttons'); ?>
            </div>


        <?php else : ?>

            <div class="flex flex-col gap-y-4 items-center justify-center rounded-[var(--blg-radius-3xl)]">
                <span>
                    <svg width="160" height="161" viewBox="0 0 160 161" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.4"
                            d="M107.934 59.289C105.334 59.289 103.267 57.2223 103.267 54.6223V46.089C103.267 39.5557 100.467 33.289 95.6671 28.889C90.7337 24.4223 84.4004 22.3557 77.7337 22.9557C66.5337 24.0223 56.7337 35.4223 56.7337 47.289V53.289C56.7337 55.889 54.6671 57.9557 52.0671 57.9557C49.4671 57.9557 47.4004 55.889 47.4004 53.289V47.289C47.4004 30.6223 60.8671 15.2223 76.8004 13.689C86.0671 12.8223 95.0004 15.7557 101.867 22.0223C108.667 28.1557 112.534 36.9557 112.534 46.089V54.6223C112.534 57.2223 110.467 59.289 107.934 59.289Z"
                            fill="#3A4654" />
                        <path d="M133.066 59.9554C127.466 53.7554 118.266 50.7554 104.8 50.7554H55.1996C41.7329 50.7554 32.5329 53.7554 26.9329 59.9554C20.4663 67.1554 20.6663 76.7554 21.3996 83.422L26.0663 120.555C27.4663 133.555 32.7329 146.889 61.3996 146.889H98.5996C127.266 146.889 132.533 133.555 133.933 120.622L138.6 83.3554C139.333 76.7554 139.533 67.1554 133.066 59.9554ZM79.9996 124.089C66.0663 124.089 54.7329 112.755 54.7329 98.822C54.7329 84.8887 66.0663 73.5554 79.9996 73.5554C93.9329 73.5554 105.266 84.8887 105.266 98.822C105.266 112.755 93.9329 124.089 79.9996 124.089Z"
                            fill="#3A4654" />
                        <path opacity="0.4"
                            d="M79.9991 124.089C93.9535 124.089 105.266 112.777 105.266 98.8223C105.266 84.8679 93.9535 73.5557 79.9991 73.5557C66.0447 73.5557 54.7324 84.8679 54.7324 98.8223C54.7324 112.777 66.0447 124.089 79.9991 124.089Z"
                            fill="#3A4654" />
                        <path d="M90.6662 102.289L87.1328 98.7556L90.4661 95.4222C92.3995 93.4889 92.3995 90.2889 90.4661 88.3556C88.5328 86.4222 85.3328 86.4222 83.3995 88.3556L80.0661 91.6889L76.5328 88.1556C74.5995 86.2222 71.3995 86.2222 69.4661 88.1556C67.5328 90.0889 67.5328 93.2889 69.4661 95.2222L72.9995 98.7556L69.3328 102.422C67.3995 104.356 67.3995 107.556 69.3328 109.489C70.3328 110.489 71.5995 110.956 72.8661 110.956C74.1328 110.956 75.3995 110.489 76.3995 109.489L80.0661 105.822L83.5995 109.356C84.5995 110.356 85.8661 110.822 87.1328 110.822C88.3995 110.822 89.6662 110.356 90.6662 109.356C92.5995 107.422 92.5995 104.289 90.6662 102.289Z"
                            fill="#3A4654" />
                    </svg>
                </span>
                <h2 class="text-2xl font-bold text-gray-800 mb-4"><?php esc_html_e('Your Cart is Empty', BLOGINA_TEXT_DOMAIN); ?></h2>
                <a href="<?php echo esc_url(wc_get_page_permalink('shop')); ?>"
                    class="inline-block px-6 py-2 bg-[var(--blg-color-secondary200)] text-white font-semibold rounded blg-btn-secondary">
                    <?php esc_html_e('Go to Shop', BLOGINA_TEXT_DOMAIN); ?>
                </a>
            </div>
        <?php endif; ?>

        <?php do_action('woocommerce_after_mini_cart'); ?>
    </div>
</div>
