<?php
/**
 * Pay for order form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-pay.php.
 *
 * @package WooCommerce\Templates
 * @version 8.2.0
 */

defined( 'ABSPATH' ) || exit;

$totals = $order->get_order_item_totals(); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
?>
<form id="order_review" method="post" class="bg-white shadow-md rounded-lg p-6">

    <table class="shop_table w-full">
        <thead>
            <tr>
                <th class="product-name text-left"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
                <th class="product-quantity text-left"><?php esc_html_e( 'Qty', 'woocommerce' ); ?></th>
                <th class="product-total text-right"><?php esc_html_e( 'Totals', 'woocommerce' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( count( $order->get_items() ) > 0 ) : ?>
                <?php foreach ( $order->get_items() as $item_id => $item ) : ?>
                    <?php
                    if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
                        continue;
                    }
                    ?>
                    <tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'order_item', $item, $order ) ); ?>">
                        <td class="product-name py-2">
                            <?php
                                echo wp_kses_post( apply_filters( 'woocommerce_order_item_name', $item->get_name(), $item, false ) );

                                do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false );

                                wc_display_item_meta( $item );

                                do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, false );
                            ?>
                        </td>
                        <td class="product-quantity py-2 text-left"><?php echo apply_filters( 'woocommerce_order_item_quantity_html', ' <strong class="product-quantity">' . sprintf( '&times;&nbsp;%s', esc_html( $item->get_quantity() ) ) . '</strong>', $item ); ?></td>
                        <td class="product-subtotal py-2 text-right"><?php echo $order->get_formatted_line_subtotal( $item ); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
        <tfoot>
            <?php if ( $totals ) : ?>
                <?php foreach ( $totals as $total ) : ?>
                    <tr>
                        <th scope="row" colspan="2" class="text-left"><?php echo $total['label']; ?></th>
                        <td class="product-total text-right"><?php echo $total['value']; ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tfoot>
    </table>

    <?php
    /**
     * Triggered from within the checkout/form-pay.php template, immediately before the payment section.
     */
    do_action( 'woocommerce_pay_order_before_payment' ); 
    ?>

    <div id="payment" class="mt-6">
        <?php if ( $order->needs_payment() ) : ?>
            <ul class="wc_payment_methods payment_methods methods space-y-4">
                <?php
                if ( ! empty( $available_gateways ) ) {
                    foreach ( $available_gateways as $gateway ) {
                        wc_get_template( 'checkout/payment-method.php', array( 'gateway' => $gateway ) );
                    }
                } else {
                    echo '<li>';
                    wc_print_notice( apply_filters( 'woocommerce_no_available_payment_methods_message', esc_html__( 'Sorry, it seems that there are no available payment methods for your location. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) ), 'notice' );
                    echo '</li>';
                }
                ?>
            </ul>
        <?php endif; ?>
        
        <div class="form-row mt-4">
            <input type="hidden" name="woocommerce_pay" value="1" />

            <?php wc_get_template( 'checkout/terms.php' ); ?>

            <?php do_action( 'woocommerce_pay_order_before_submit' ); ?>

            <button type="submit" class="button alt bg-blue-600 text-white font-semibold py-2 px-4 rounded hover:bg-blue-700 transition-colors duration-200" id="place_order" value="<?php esc_attr_e( $order_button_text ); ?>" data-value="<?php esc_attr_e( $order_button_text ); ?>">
                <?php esc_html_e( $order_button_text ); ?>
            </button>

            <?php do_action( 'woocommerce_pay_order_after_submit' ); ?>

            <?php wp_nonce_field( 'woocommerce-pay', 'woocommerce-pay-nonce' ); ?>
        </div>
    </div>
</form>
