<?php
/**
 * Checkout Order Receipt Template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/order-receipt.php.
 *
 * @package WooCommerce\Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="order-receipt bg-white p-6 rounded-lg shadow-md">
    <h2 class="text-lg font-semibold mb-4"><?php esc_html_e( 'Order Details', 'woocommerce' ); ?></h2>

    <ul class="order_details space-y-4">
        <li class="order flex justify-between">
            <span><?php esc_html_e( 'Order number:', 'woocommerce' ); ?></span>
            <strong><?php echo esc_html( $order->get_order_number() ); ?></strong>
        </li>
        <li class="date flex justify-between">
            <span><?php esc_html_e( 'Date:', 'woocommerce' ); ?></span>
            <strong><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></strong>
        </li>
        <li class="total flex justify-between">
            <span><?php esc_html_e( 'Total:', 'woocommerce' ); ?></span>
            <strong><?php echo wp_kses_post( $order->get_formatted_order_total() ); ?></strong>
        </li>
        <?php if ( $order->get_payment_method_title() ) : ?>
            <li class="method flex justify-between">
                <span><?php esc_html_e( 'Payment method:', 'woocommerce' ); ?></span>
                <strong><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></strong>
            </li>
        <?php endif; ?>
    </ul>

    <?php do_action( 'woocommerce_receipt_' . $order->get_payment_method(), $order->get_id() ); ?>
</div>

<div class="clear"></div>
