<?php

/**
 * Output a single payment method
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/payment-method.php.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.5.0
 */

if (! defined('ABSPATH')) {
	exit;
}
?>
<li class="wc_payment_method payment_method_<?php echo esc_attr($gateway->id); ?> bg-white flex items-start gap-x-8 transition-all">
	<input
		id="payment_method_<?php echo esc_attr($gateway->id); ?>"
		type="radio"
		class="input-radio !m-0 !p-0 !shadow-none !h-8 !w-8 text-[var(--blg-color-secondary200)] focus:ring-[var(--blg-color-secondary200)]"
		name="payment_method"
		value="<?php echo esc_attr($gateway->id); ?>"
		<?php checked($gateway->chosen, true); ?>
		data-order_button_text="<?php echo esc_attr($gateway->order_button_text); ?>" />
	<div>
		<?php
		// Check for the specific gateway and assign the correct SVG icon
		$icon = '';
		if ($gateway->id === 'cod') { // Cash on delivery
			echo '<svg xmlns="http://www.w3.org/2000/svg" width="36" height="37" viewBox="0 0 36 37" fill="none">
                        <path d="M3 33.9741H33" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M4.42578 33.974L4.50079 15.929C4.50079 15.014 4.93578 14.1441 5.65578 13.5741L16.1558 5.39904C17.2358 4.55904 18.7508 4.55904 19.8458 5.39904L30.3458 13.559C31.0808 14.129 31.5008 14.999 31.5008 15.929V33.974" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linejoin="round"/>
                        <path d="M23.25 17.4741H12.75C11.505 17.4741 10.5 18.4791 10.5 19.7241V33.9741H25.5V19.7241C25.5 18.4791 24.495 17.4741 23.25 17.4741Z" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M15 25.3491V27.5991" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M15.75 12.2241H20.25" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>';
		} elseif ($gateway->id === 'bacs') { // Online payment (custom ID, change this according to your payment gateway ID)
			echo '<svg xmlns="http://www.w3.org/2000/svg" width="36" height="37" viewBox="0 0 36 37" fill="none">
  <path d="M3 13.7241H19.5" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M9 25.7241H12" stroke="var(--blg-color-secondary200)"
   stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M15.75 25.7241H21.75" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M33 17.9691V25.1391C33 30.4041 31.665 31.7241 26.34 31.7241H9.66C4.335 31.7241 3 30.4041 3 25.1391V12.8091C3 7.54414 4.335 6.22412 9.66 6.22412H19.92" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M25.5 5.84912H30.195C31.23 5.84912 32.07 6.79412 32.07 7.72412C32.07 8.75912 31.23 9.59912 30.195 9.59912H25.5V5.84912Z" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M25.5 9.59912H30.855C32.04 9.59912 33 10.4391 33 11.4741C33 12.5091 32.04 13.3491 30.855 13.3491H25.5V9.59912Z" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M28.1406 13.3491V15.2241" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M28.1406 3.97412V5.84912" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M27.285 5.84912H24" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
  <path d="M27.285 13.3491H24" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>';
		} else {
			if ($gateway->get_icon()) {
				echo $gateway->get_icon();
			} else {
				// Default icon if none is set
				echo '<svg xmlns="http://www.w3.org/2000/svg" width="36" height="37" viewBox="0 0 36 37" fill="none">
                        <path d="M3 33.9741H33" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M4.42578 33.974L4.50079 15.929C4.50079 15.014 4.93578 14.1441 5.65578 13.5741L16.1558 5.39904C17.2358 4.55904 18.7508 4.55904 19.8458 5.39904L30.3458 13.559C31.0808 14.129 31.5008 14.999 31.5008 15.929V33.974" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linejoin="round"/>
                        <path d="M23.25 17.4741H12.75C11.505 17.4741 10.5 18.4791 10.5 19.7241V33.9741H25.5V19.7241C25.5 18.4791 24.495 17.4741 23.25 17.4741Z" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M15 25.3491V27.5991" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M15.75 12.2241H20.25" stroke="var(--blg-color-secondary200)" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>';
			}
		}
		?>
	</div>
	<div class="flex flex-col">
		<label
			for="payment_method_<?php echo esc_attr($gateway->id); ?>"
			class="flex items-center cursor-pointer font-bold text-[var(--blg-color-primary500)] text-[15px] gap-x-2">
			<?php echo $gateway->get_title(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?>
			<?php echo $gateway->get_icon(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?>
		</label>

		<?php if ($gateway->has_fields() || $gateway->get_description()) : ?>
			<div class="payment_box payment_method_<?php echo esc_attr($gateway->id); ?> !p-0 !m-0 !text-[15px] !text-[var(--blg-gray)] <?php if (! $gateway->chosen) : ?>hidden<?php endif; ?>">
				<?php $gateway->payment_fields(); ?>
			</div>
		<?php endif; ?>
	</div>
</li>

<style>
	/* Base styles for the radio button */
	.input-radio {
		appearance: none !important;
		/* Hide default radio button */
		width: 32px !important;
		min-width: 32px !important;
		height: 32px !important;
		min-height: 32px !important;
		border: 2px solid var(--blg-color-secondary200) !important;
		/* Unchecked border color */
		border-radius: 50% !important;
		/* Make it circular */
		background: white;
		/* Default background color */
		display: flex;
		align-items: center;
		justify-content: center;
		cursor: pointer;
		transition: background 0.3s, border-color 0.3s;
		position: relative;
		margin: 0 !important;
	}

	/* Checked state */
	.input-radio:checked {
		border: none !important;
	}

	/* Add the SVG checkmark icon for checked state */
	.input-radio:checked::after {
		content: "" !important;
		position: absolute !important;
		top: 50% !important;
		left: 50% !important;
		transform: translate(-50%, -50%) !important;
		width: 100% !important;
		/* Fill the entire radio button */
		height: 100% !important;
		/* Fill the entire radio button */
		background: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33" fill="none"><path d="M16.0013 3.64087C8.65463 3.64087 2.66797 9.62754 2.66797 16.9742C2.66797 24.3209 8.65463 30.3075 16.0013 30.3075C23.348 30.3075 29.3346 24.3209 29.3346 16.9742C29.3346 9.62754 23.348 3.64087 16.0013 3.64087ZM22.3746 13.9075L14.8146 21.4675C14.628 21.6542 14.3746 21.7609 14.108 21.7609C13.8413 21.7609 13.588 21.6542 13.4013 21.4675L9.62797 17.6942C9.2413 17.3075 9.2413 16.6675 9.62797 16.2809C10.0146 15.8942 10.6546 15.8942 11.0413 16.2809L14.108 19.3475L20.9613 12.4942C21.348 12.1075 21.988 12.1075 22.3746 12.4942C22.7613 12.8809 22.7613 13.5075 22.3746 13.9075Z" fill="%23FF8A00"/></svg>') no-repeat center;
		background-size: contain !important;
	}

	/* Hover effect */
	.input-radio:hover {
		border-color: var(--blg-color-secondary200) !important;
		/* Optional hover border */
	}
</style>