<?php

/**
 * Orders
 *
 * Shows orders on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/orders.php.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.5.0
 */

defined('ABSPATH') || exit;

// Fetch customer orders from WooCommerce session or account
$customer_orders = wc_get_orders(array('customer_id' => get_current_user_id()));
$has_orders = !empty($customer_orders); // Check if there are any orders

do_action('woocommerce_before_account_orders', $has_orders); ?>
<div class="mx-auto <?php echo $has_orders ? '!bg-white' : 'bg-[var(--blg-color-primary100)] flex items-center justify-center flex-col px-6 md:px-12 lg:px-48 py-20'; ?> p-6 blg-shadow-sm rounded-[var(--blg-radius-3xl)] my-4">

	<?php if ($has_orders) : ?>
		<div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 text-nowrap gap-4 mb-3 text-center font-bold text-[var(--blg-color-primary500)] font-['Pinar'] p-5 bg-[var(--blg-color-primary100)] rounded-2xl">
			<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2"><?php esc_html_e('Order Number', 'woocommerce'); ?></div>
			<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2"><?php esc_html_e('Order Date', 'woocommerce'); ?></div>
			<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2"><?php esc_html_e('Status', 'woocommerce'); ?></div>
			<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2"><?php esc_html_e('Total', 'woocommerce'); ?></div>
			<div class="lg:pl-2 py-2"><?php esc_html_e('Actions', 'woocommerce'); ?></div>
		</div>
		<div class="flex flex-col gap-y-2 overflow-x-auto text-nowrap text-center p-5 bg-[var(--blg-color-primary100)] rounded-2xl">
			<?php foreach ($customer_orders as $customer_order) :
				$order = wc_get_order($customer_order); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
				$item_count = $order->get_item_count() - $order->get_item_count_refunded(); ?>
				<div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-4 items-center">
					<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2 text-[var(--blg-gray)]">
						<a href="<?php echo esc_url($order->get_view_order_url()); ?>" aria-label="<?php echo esc_attr(sprintf(__('View order number %s', 'woocommerce'), $order->get_order_number())); ?>">
							<?php echo $order->get_order_number(); ?>
						</a>
					</div>
					<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2 text-[var(--blg-gray)]">
						<time datetime="<?php echo esc_attr($order->get_date_created()->date('c')); ?>"><?php echo BLOGINA_JALALI::display_jalali_date(esc_html(wc_format_datetime($order->get_date_created()))); ?></time>
					</div>
					<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2 text-[var(--blg-gray)]"><?php echo esc_html(wc_get_order_status_name($order->get_status())); ?></div>
					<div class="lg:border-l lg:border-gray-300 lg:pl-2 py-2 text-[var(--blg-gray)]"><?php echo wp_kses_post(sprintf(_n('%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'woocommerce'), $order->get_formatted_order_total(), $item_count)); ?></div>
					<div class="text-[var(--blg-gray)]">
						<?php
						$actions = wc_get_account_orders_actions($order);

						if (!empty($actions)) foreach ($actions as $key => $action) echo '<a href="' . esc_url($action['url']) . '" class="inline-flex items-center hover:text-white px-4 py-2 blg-btn-primary" aria-label="' . esc_attr(sprintf(__('View order number %s', 'woocommerce'), $order->get_order_number())) . '">' . esc_html($action['name']) . '</a>';
						?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php else : ?>
		<div class="flex flex-col gap-y-4 items-center justify-center">
			<span>
				<svg width="160" height="161" viewBox="0 0 160 161" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path opacity="0.4" d="M107.934 59.289C105.334 59.289 103.267 57.2223 103.267 54.6223V46.089C103.267 39.5557 100.467 33.289 95.6671 28.889C90.7337 24.4223 84.4004 22.3557 77.7337 22.9557C66.5337 24.0223 56.7337 35.4223 56.7337 47.289V53.289C56.7337 55.889 54.6671 57.9557 52.0671 57.9557C49.4671 57.9557 47.4004 55.889 47.4004 53.289V47.289C47.4004 30.6223 60.8671 15.2223 76.8004 13.689C86.0671 12.8223 95.0004 15.7557 101.867 22.0223C108.667 28.1557 112.534 36.9557 112.534 46.089V54.6223C112.534 57.2223 110.467 59.289 107.934 59.289Z" fill="#3A4654" />
					<path d="M133.066 59.9554C127.466 53.7554 118.266 50.7554 104.8 50.7554H55.1996C41.7329 50.7554 32.5329 53.7554 26.9329 59.9554C20.4663 67.1554 20.6663 76.7554 21.3996 83.422L26.0663 120.555C27.4663 133.555 32.7329 146.889 61.3996 146.889H98.5996C127.266 146.889 132.533 133.555 133.933 120.622L138.6 83.3554C139.333 76.7554 139.533 67.1554 133.066 59.9554ZM79.9996 124.089C66.0663 124.089 54.7329 112.755 54.7329 98.822C54.7329 84.8887 66.0663 73.5554 79.9996 73.5554C93.9329 73.5554 105.266 84.8887 105.266 98.822C105.266 112.755 93.9329 124.089 79.9996 124.089Z" fill="#3A4654" />
					<path opacity="0.4" d="M79.9991 124.089C93.9535 124.089 105.266 112.777 105.266 98.8223C105.266 84.8679 93.9535 73.5557 79.9991 73.5557C66.0447 73.5557 54.7324 84.8679 54.7324 98.8223C54.7324 112.777 66.0447 124.089 79.9991 124.089Z" fill="#3A4654" />
					<path d="M90.6662 102.289L87.1328 98.7556L90.4661 95.4222C92.3995 93.4889 92.3995 90.2889 90.4661 88.3556C88.5328 86.4222 85.3328 86.4222 83.3995 88.3556L80.0661 91.6889L76.5328 88.1556C74.5995 86.2222 71.3995 86.2222 69.4661 88.1556C67.5328 90.0889 67.5328 93.2889 69.4661 95.2222L72.9995 98.7556L69.3328 102.422C67.3995 104.355 67.3995 107.555 69.3328 109.488C71.3995 111.422 74.5995 111.422 76.5328 109.488L80.0661 105.955L83.5995 109.488C85.5328 111.422 88.7328 111.422 90.6662 109.488C92.5995 107.555 92.5995 104.355 90.6662 102.289Z" fill="#3A4654" />
				</svg>
			</span>
			<p class="text-xl font-bold text-[var(--blg-color-secondary500)]"><?php esc_html_e('You have no orders yet.', BLOGINA_TEXT_DOMAIN); ?></p>
			<a class="bg-[var(--blg-color-primary500)] text-white hover:bg-[var(--blg-color-secondary500)] text-sm px-6 py-2 rounded" href="<?php echo esc_url(wc_get_page_permalink('shop')); ?>"><?php esc_html_e('Go shop now', BLOGINA_TEXT_DOMAIN); ?></a>
		</div>
	<?php endif; ?>
</div>

<?php do_action('woocommerce_after_account_orders', $has_orders); ?>
